import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */
import React, { forwardRef, memo, useMemo } from 'react';
import { css, jsx } from '@emotion/react';
import { useGlobalTheme } from '@atlaskit/theme/components';
import CodeBidiWarning from './bidi-warning';
import codeBidiWarningDecorator from './bidi-warning/bidi-warning-decorator';
import { getCodeStyles } from './internal/theme/styles';
/**
 * __Code__
 *
 * Code highlights short strings of code snippets inline with body text.
 *
 * - [Examples](https://atlassian.design/components/code/examples)
 * - [Code](https://atlassian.design/components/code/code)
 * - [Usage](https://atlassian.design/components/code/usage)
 */
const Code = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function Code({
  testId,
  ...props
}, ref) {
  const theme = useGlobalTheme();
  const styles = useMemo(() => css(getCodeStyles(theme)), [theme]);
  const {
    children,
    codeBidiWarnings = true,
    codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled = true,
    ...otherProps
  } = props;
  const decoratedChildren = codeBidiWarnings ? jsx(RenderCodeChildrenWithBidiWarnings, {
    codeBidiWarningLabel: codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
  }, children) : children;
  return jsx("code", _extends({
    ref: ref,
    "data-testid": testId,
    css: styles
  }, otherProps), decoratedChildren);
}));
function RenderCodeChildrenWithBidiWarnings({
  children,
  codeBidiWarningLabel,
  codeBidiWarningTooltipEnabled
}) {
  const replacedChildren = React.Children.map(children, childNode => {
    if (typeof childNode === 'string') {
      const decorated = codeBidiWarningDecorator(childNode, ({
        bidiCharacter,
        index
      }) => jsx(CodeBidiWarning, {
        bidiCharacter: bidiCharacter,
        key: index,
        label: codeBidiWarningLabel,
        tooltipEnabled: codeBidiWarningTooltipEnabled
      }));
      return decorated;
    }
    if (isReactElement(childNode) && childNode.props.children) {
      // eslint-disable-next-line @repo/internal/react/no-clone-element
      const newChildNode = /*#__PURE__*/React.cloneElement(childNode, {
        children: jsx(RenderCodeChildrenWithBidiWarnings, {
          codeBidiWarningLabel: codeBidiWarningLabel,
          codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
        }, childNode.props.children)
      });
      return newChildNode;
    }
    return childNode;
  });
  return jsx(React.Fragment, null, replacedChildren);
}
function isReactElement(child) {
  return !!child.type;
}
Code.displayName = 'Code';
export { getCodeStyles };
export default Code;