import memoizeOne from 'memoize-one';
import * as colors from '@atlaskit/theme/colors';
import { themed } from '@atlaskit/theme/components';
import { codeFontFamily } from '@atlaskit/theme/constants';
// Hardcoded values have been used due to the current color palette not having any
// accessible color options for Teal and Yellow and +20A
const T800 = '#067384';
const Y1100 = '#7A5D1A';
const PLUS20 = '#3A434E';
export const getBaseTheme = theme => ({
  fontFamily: codeFontFamily(),
  fontFamilyItalic: `SFMono-MediumItalic, ${codeFontFamily()}`,
  backgroundColor: themed({
    light: `var(--ds-background-neutral, ${colors.N20})`,
    dark: `var(--ds-background-neutral, ${colors.DN50})`
  })({
    theme
  }),
  textColor: themed({
    light: `var(--ds-text, ${colors.N800})`,
    dark: `var(--ds-text, ${colors.DN800})`
  })({
    theme
  }),
  lineNumberColor: themed({
    light: `var(--ds-text-subtlest, ${colors.N400})`,
    dark: `var(--ds-text-subtlest, ${colors.DN400})`
  })({
    theme
  }),
  lineNumberBgColor: themed({
    light: `var(--ds-background-neutral, ${colors.N30})`,
    dark: `var(--ds-background-neutral, ${colors.DN20})`
  })({
    theme
  })
});
export const defaultBaseTheme = getBaseTheme({
  mode: 'light'
});
export const getColorPalette = memoizeOne(theme => {
  const akTheme = {
    theme
  };
  return {
    highlightedLineBgColor: themed({
      light: `var(--ds-background-neutral, ${colors.N30})`,
      dark: `var(--ds-background-neutral, ${PLUS20})`
    })(akTheme),
    highlightedLineBorderColor: themed({
      light: `var(--ds-border-focused, ${colors.B200})`,
      dark: `var(--ds-border-focused, ${colors.B100})`
    })(akTheme),
    substringColor: themed({
      light: `var(--ds-text-subtlest, ${colors.N400})`,
      dark: `var(--ds-text-subtlest, ${colors.DN400})`
    })(akTheme),
    keywordColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    attributeColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    selectorTagColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    docTagColor: themed({
      light: `var(--ds-text-accent-yellow, ${Y1100})`,
      dark: `var(--ds-text-accent-yellow, ${colors.Y300})`
    })(akTheme),
    nameColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    builtInColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    literalColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    bulletColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    codeColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    regexpColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    symbolColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    variableColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    templateVariableColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    linkColor: themed({
      light: `var(--ds-text-accent-purple, ${colors.P300})`,
      dark: `var(--ds-text-accent-purple, ${colors.P75})`
    })(akTheme),
    selectorAttributeColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    selectorPseudoColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T200})`
    })(akTheme),
    typeColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    stringColor: themed({
      light: `var(--ds-text-accent-green, ${colors.G500})`,
      dark: `var(--ds-text-accent-green, ${colors.G200})`
    })(akTheme),
    selectorIdColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    selectorClassColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    quoteColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    templateTagColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    titleColor: themed({
      light: `var(--ds-text-accent-purple, ${colors.P300})`,
      dark: `var(--ds-text-accent-purple, ${colors.P75})`
    })(akTheme),
    sectionColor: themed({
      light: `var(--ds-text-accent-purple, ${colors.P300})`,
      dark: `var(--ds-text-accent-purple, ${colors.P75})`
    })(akTheme),
    commentColor: themed({
      light: `var(--ds-text-subtlest, ${colors.N400})`,
      dark: `var(--ds-text-subtlest, ${colors.DN400})`
    })(akTheme),
    metaKeywordColor: themed({
      light: `var(--ds-text-accent-green, ${colors.G500})`,
      dark: `var(--ds-text-accent-green, ${colors.G200})`
    })(akTheme),
    metaColor: themed({
      light: `var(--ds-text-subtlest, ${colors.N400})`,
      dark: `var(--ds-text-subtlest, ${colors.DN400})`
    })(akTheme),
    functionColor: themed({
      light: `var(--ds-text, ${colors.N800})`,
      dark: `var(--ds-text, ${colors.DN800})`
    })(akTheme),
    numberColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    prologColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    cdataColor: themed({
      light: `var(--ds-text-subtlest, ${colors.N400})`,
      dark: `var(--ds-text-subtlest, ${colors.B75})`
    })(akTheme),
    punctuationColor: themed({
      light: `var(--ds-text, ${colors.N800})`,
      dark: `var(--ds-text, ${colors.DN800})`
    })(akTheme),
    propertyColor: themed({
      light: `var(--ds-text-accent-purple, ${colors.P300})`,
      dark: `var(--ds-text-accent-purple, ${colors.P75})`
    })(akTheme),
    constantColor: themed({
      light: `var(--ds-text-accent-teal, ${T800})`,
      dark: `var(--ds-text-accent-teal, ${colors.T100})`
    })(akTheme),
    booleanColor: themed({
      light: `var(--ds-text-accent-blue, ${colors.B400})`,
      dark: `var(--ds-text-accent-blue, ${colors.B75})`
    })(akTheme),
    charColor: themed({
      light: `var(--ds-text, ${colors.N800})`,
      dark: `var(--ds-text, ${colors.DN800})`
    })(akTheme),
    insertedColor: themed({
      light: `var(--ds-text-accent-green, ${colors.G500})`,
      dark: `var(--ds-text-accent-green, ${colors.B75})`
    })(akTheme),
    deletedColor: themed({
      light: `var(--ds-text-accent-red, ${colors.R500})`,
      dark: `var(--ds-text-accent-red, ${colors.B75})`
    })(akTheme),
    operatorColor: themed({
      light: `var(--ds-text, ${colors.N800})`,
      dark: `var(--ds-text, ${colors.B75})`
    })(akTheme),
    atruleColor: themed({
      light: `var(--ds-text-accent-green, ${colors.G500})`,
      dark: `var(--ds-text-accent-green, ${colors.G200})`
    })(akTheme),
    importantColor: themed({
      light: `var(--ds-text-accent-yellow, ${Y1100})`,
      dark: `var(--ds-text-accent-yellow, ${colors.Y300})`
    })(akTheme)
  };
});
const getTheme = theme => ({
  ...getBaseTheme(theme),
  ...getColorPalette(theme)
});
export default getTheme;