import memoizeOne from 'memoize-one';
import { SUPPORTED_LANGUAGES } from '../../constants';
export const normalizeLanguage = memoizeOne(language => {
  if (!language) {
    return '';
  }
  const match = SUPPORTED_LANGUAGES.find(val => {
    return val.name === language || val.alias.includes(language);
  });
  // Fallback to plain monospaced text if language passed but not supported
  return match ? match.value : 'text';
});