import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React from 'react';
import highlight from './lib/highlight';
// Uses the loader method of async bundling
// Instantiates highligher as a singleton, loading refractor only once per page (refractor/prism are singleton modules)
const generator = options => {
  const {
    loader
  } = options;

  // eslint-disable-next-line @repo/internal/react/no-class-components
  class AsyncHighlighter extends React.PureComponent {
    // Useful in tests
    static preload() {
      return AsyncHighlighter.loadAstGenerator();
    }
    static loadAstGenerator() {
      AsyncHighlighter.astGeneratorPromise = loader().then(astGenerator => {
        AsyncHighlighter.astGenerator = astGenerator;
        return astGenerator;
      });
      return AsyncHighlighter.astGeneratorPromise;
    }
    componentDidMount() {
      if (!AsyncHighlighter.astGeneratorPromise) {
        AsyncHighlighter.loadAstGenerator();
      }
      if (!AsyncHighlighter.astGenerator && AsyncHighlighter.astGeneratorPromise) {
        AsyncHighlighter.astGeneratorPromise.then(() => {
          this.forceUpdate();
        });
      }
    }
    render() {
      return /*#__PURE__*/React.createElement(AsyncHighlighter.highlightInstance, _extends({}, this.props, {
        astGenerator: AsyncHighlighter.astGenerator
      }));
    }
  }
  _defineProperty(AsyncHighlighter, "astGenerator", null);
  _defineProperty(AsyncHighlighter, "highlightInstance", highlight);
  return AsyncHighlighter;
};
export default generator({
  loader: () => import( /* webpackChunkName: "@atlaskit-internal_refractor-import" */
  'refractor').then(module => {
    // Webpack 3 returns module.exports as default as module, but webpack 4 returns module.exports as module.default
    return module.default || module;
  })
});