import React from 'react';
import CodeBidiWarning from '../../../bidi-warning';
import codeBidiWarningDecorator from '../../../bidi-warning/bidi-warning-decorator';
import createChildren from './create-children';
function createClassNameString(classNames) {
  return classNames ? classNames.join(' ') : '';
}

// NOTE: This is a function call rather than a React component because, for
// unknown reasons, it appears to be more performant. We tried and measured both
// and this stacks up better than as a memoised React component. Something to look
// into in the future.
export default function createElement({
  node,
  codeBidiWarningConfig,
  key
}) {
  if (node.type === 'text') {
    const {
      value
    } = node;
    // occasionally a numeric value is passed when the type is text
    const textValue = `${value}`;
    if (codeBidiWarningConfig.codeBidiWarnings) {
      const decorated = codeBidiWarningDecorator(textValue, ({
        bidiCharacter,
        index
      }) => /*#__PURE__*/React.createElement(CodeBidiWarning, {
        bidiCharacter: bidiCharacter,
        key: index,
        label: codeBidiWarningConfig.codeBidiWarningLabel,
        tooltipEnabled: codeBidiWarningConfig.codeBidiWarningTooltipEnabled
      }));
      return decorated;
    }
    return textValue;
  } else {
    const {
      properties,
      tagName
    } = node;
    const childrenCreator = createChildren(codeBidiWarningConfig);
    const props = {
      ...properties,
      className: createClassNameString(properties.className)
    };
    const children = childrenCreator(node.children);
    return /*#__PURE__*/React.createElement(tagName, {
      key,
      ...props
    }, children);
  }
}