import React from 'react';
import createElement from './create-element';

/**
 * __React Renderer__
 *
 * A component that receives processed code lines and renders them into the code
 * rows inside the wrapping span and nested code tag, applying passed props and
 * code bidi warning config settings.
 */
export default function ReactRenderer({
  containerProps,
  codeTagProps,
  rows,
  codeBidiWarningConfig
}) {
  const renderedRows = rows.map((node, i) => createElement({
    node,
    codeBidiWarningConfig,
    key: `code-segment${i}`
  }));
  return /*#__PURE__*/React.createElement("span", containerProps, /*#__PURE__*/React.createElement("code", codeTagProps, renderedRows));
}