import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children"];
import React from 'react';
import Tooltip from '@atlaskit/tooltip';
import { Decorator } from './styled';
/**
 * __Bidi Warning__
 *
 * A component used to render a bidi character warning.
 * A bidi character can be used to perform a "bidi override attack".
 *
 * See https://hello.atlassian.net/wiki/spaces/PRODSEC/pages/1347434677/PSHELP-2943+Investigate+Trojan+Source+Attack+Vulnerability#1)-Providing-visual-cues-for-our-Customers-in-our-affected-products
 */
export default function BidiWarning(_ref) {
  var testId = _ref.testId,
    bidiCharacter = _ref.bidiCharacter,
    skipChildren = _ref.skipChildren,
    tooltipEnabled = _ref.tooltipEnabled,
    _ref$label = _ref.label,
    label = _ref$label === void 0 ? 'Bidirectional characters change the order that text is rendered. This could be used to obscure malicious code.' : _ref$label;
  if (tooltipEnabled) {
    return (
      /*#__PURE__*/
      // Following patches, this should be updated to use the render props signature which will provide aria attributes.
      // Note: this should be tested, as initial testing did not see attributes work with current tooltip implementation.
      React.createElement(Tooltip, {
        content: label,
        tag: CustomizedTagWithRef
      }, /*#__PURE__*/React.createElement(Decorator, {
        testId: testId,
        bidiCharacter: bidiCharacter
      }, skipChildren ? null : bidiCharacter))
    );
  }
  return /*#__PURE__*/React.createElement(Decorator, {
    testId: testId,
    bidiCharacter: bidiCharacter
  }, skipChildren ? null : bidiCharacter);
}
var CustomizedTagWithRef = /*#__PURE__*/React.forwardRef(function (props, ref) {
  var children = props.children,
    rest = _objectWithoutProperties(props, _excluded);
  return /*#__PURE__*/React.createElement("span", _extends({}, rest, {
    ref: ref
  }), children);
});