import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["testId"],
  _excluded2 = ["children", "codeBidiWarnings", "codeBidiWarningLabel", "codeBidiWarningTooltipEnabled"];
/** @jsx jsx */
import React, { forwardRef, memo, useMemo } from 'react';
import { css, jsx } from '@emotion/react';
import { useGlobalTheme } from '@atlaskit/theme/components';
import CodeBidiWarning from './bidi-warning';
import codeBidiWarningDecorator from './bidi-warning/bidi-warning-decorator';
import { getCodeStyles } from './internal/theme/styles';
/**
 * __Code__
 *
 * Code highlights short strings of code snippets inline with body text.
 *
 * - [Examples](https://atlassian.design/components/code/examples)
 * - [Code](https://atlassian.design/components/code/code)
 * - [Usage](https://atlassian.design/components/code/usage)
 */
var Code = /*#__PURE__*/memo( /*#__PURE__*/forwardRef(function Code(_ref, ref) {
  var testId = _ref.testId,
    props = _objectWithoutProperties(_ref, _excluded);
  var theme = useGlobalTheme();
  var styles = useMemo(function () {
    return css(getCodeStyles(theme));
  }, [theme]);
  var children = props.children,
    _props$codeBidiWarnin = props.codeBidiWarnings,
    codeBidiWarnings = _props$codeBidiWarnin === void 0 ? true : _props$codeBidiWarnin,
    codeBidiWarningLabel = props.codeBidiWarningLabel,
    _props$codeBidiWarnin2 = props.codeBidiWarningTooltipEnabled,
    codeBidiWarningTooltipEnabled = _props$codeBidiWarnin2 === void 0 ? true : _props$codeBidiWarnin2,
    otherProps = _objectWithoutProperties(props, _excluded2);
  var decoratedChildren = codeBidiWarnings ? jsx(RenderCodeChildrenWithBidiWarnings, {
    codeBidiWarningLabel: codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
  }, children) : children;
  return jsx("code", _extends({
    ref: ref,
    "data-testid": testId,
    css: styles
  }, otherProps), decoratedChildren);
}));
function RenderCodeChildrenWithBidiWarnings(_ref2) {
  var children = _ref2.children,
    codeBidiWarningLabel = _ref2.codeBidiWarningLabel,
    codeBidiWarningTooltipEnabled = _ref2.codeBidiWarningTooltipEnabled;
  var replacedChildren = React.Children.map(children, function (childNode) {
    if (typeof childNode === 'string') {
      var decorated = codeBidiWarningDecorator(childNode, function (_ref3) {
        var bidiCharacter = _ref3.bidiCharacter,
          index = _ref3.index;
        return jsx(CodeBidiWarning, {
          bidiCharacter: bidiCharacter,
          key: index,
          label: codeBidiWarningLabel,
          tooltipEnabled: codeBidiWarningTooltipEnabled
        });
      });
      return decorated;
    }
    if (isReactElement(childNode) && childNode.props.children) {
      // eslint-disable-next-line @repo/internal/react/no-clone-element
      var newChildNode = /*#__PURE__*/React.cloneElement(childNode, {
        children: jsx(RenderCodeChildrenWithBidiWarnings, {
          codeBidiWarningLabel: codeBidiWarningLabel,
          codeBidiWarningTooltipEnabled: codeBidiWarningTooltipEnabled
        }, childNode.props.children)
      });
      return newChildNode;
    }
    return childNode;
  });
  return jsx(React.Fragment, null, replacedChildren);
}
function isReactElement(child) {
  return !!child.type;
}
Code.displayName = 'Code';
export { getCodeStyles };
export default Code;