import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import { useCallback, useMemo } from 'react';
var DEFAULT_LINE_EL_ATTR_OBJ = {
  'data-ds--code--row': ''
};
var getLineStyleObject = function getLineStyleObject(lineNumber, testId) {
  return testId ? _objectSpread({
    'data-testid': "".concat(testId, "-line-").concat(lineNumber)
  }, DEFAULT_LINE_EL_ATTR_OBJ) : DEFAULT_LINE_EL_ATTR_OBJ;
};
export var useHighlightLines = function useHighlightLines(_ref) {
  var _ref$highlight = _ref.highlight,
    highlight = _ref$highlight === void 0 ? '' : _ref$highlight,
    testId = _ref.testId;
  var highlightedLines = useMemo(function () {
    if (!highlight) {
      return [];
    }
    return highlight.split(',').map(function (num) {
      if (num.indexOf('-') > 0) {
        // We found a line group, e.g. 1-3
        var _num$split$map$sort = num.split('-').map(Number)
          // Sort by lowest value first, highest value last.
          .sort(function (a, b) {
            return a - b;
          }),
          _num$split$map$sort2 = _slicedToArray(_num$split$map$sort, 2),
          from = _num$split$map$sort2[0],
          to = _num$split$map$sort2[1];
        return Array(to + 1).fill(undefined).map(function (_, index) {
          return index;
        }).slice(from, to + 1);
      }
      return Number(num);
    }).reduce(function (acc, val) {
      return acc.concat(val);
    }, []) || [];
  }, [highlight]);
  var getHighlightStyles = useCallback(function (lineNumber, highlightedLines) {
    if (!highlight || highlightedLines.length === 0) {
      return getLineStyleObject(lineNumber, testId);
    }
    if (highlightedLines.includes(lineNumber)) {
      var highlightedDataAttrObj = {
        'data-ds--code--row--highlight': ''
      };
      return _objectSpread(_objectSpread({}, highlightedDataAttrObj), getLineStyleObject(lineNumber, testId));
    }
    return getLineStyleObject(lineNumber, testId);
  }, [highlight, testId]);
  return {
    getHighlightStyles: getHighlightStyles,
    highlightedLines: highlightedLines
  };
};