import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import memoizeOne from 'memoize-one';
import * as colors from '@atlaskit/theme/colors';
import { themed } from '@atlaskit/theme/components';
import { codeFontFamily } from '@atlaskit/theme/constants';
// Hardcoded values have been used due to the current color palette not having any
// accessible color options for Teal and Yellow and +20A
var T800 = '#067384';
var Y1100 = '#7A5D1A';
var PLUS20 = '#3A434E';
export var getBaseTheme = function getBaseTheme(theme) {
  return {
    fontFamily: codeFontFamily(),
    fontFamilyItalic: "SFMono-MediumItalic, ".concat(codeFontFamily()),
    backgroundColor: themed({
      light: "var(--ds-background-neutral, ".concat(colors.N20, ")"),
      dark: "var(--ds-background-neutral, ".concat(colors.DN50, ")")
    })({
      theme: theme
    }),
    textColor: themed({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })({
      theme: theme
    }),
    lineNumberColor: themed({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })({
      theme: theme
    }),
    lineNumberBgColor: themed({
      light: "var(--ds-background-neutral, ".concat(colors.N30, ")"),
      dark: "var(--ds-background-neutral, ".concat(colors.DN20, ")")
    })({
      theme: theme
    })
  };
};
export var defaultBaseTheme = getBaseTheme({
  mode: 'light'
});
export var getColorPalette = memoizeOne(function (theme) {
  var akTheme = {
    theme: theme
  };
  return {
    highlightedLineBgColor: themed({
      light: "var(--ds-background-neutral, ".concat(colors.N30, ")"),
      dark: "var(--ds-background-neutral, ".concat(PLUS20, ")")
    })(akTheme),
    highlightedLineBorderColor: themed({
      light: "var(--ds-border-focused, ".concat(colors.B200, ")"),
      dark: "var(--ds-border-focused, ".concat(colors.B100, ")")
    })(akTheme),
    substringColor: themed({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    keywordColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    attributeColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    selectorTagColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    docTagColor: themed({
      light: "var(--ds-text-accent-yellow, ".concat(Y1100, ")"),
      dark: "var(--ds-text-accent-yellow, ".concat(colors.Y300, ")")
    })(akTheme),
    nameColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    builtInColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    literalColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    bulletColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    codeColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    regexpColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    symbolColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    variableColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    templateVariableColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    linkColor: themed({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    selectorAttributeColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    selectorPseudoColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T200, ")")
    })(akTheme),
    typeColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    stringColor: themed({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    selectorIdColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    selectorClassColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    quoteColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    templateTagColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    titleColor: themed({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    sectionColor: themed({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    commentColor: themed({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    metaKeywordColor: themed({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    metaColor: themed({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.DN400, ")")
    })(akTheme),
    functionColor: themed({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    numberColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    prologColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    cdataColor: themed({
      light: "var(--ds-text-subtlest, ".concat(colors.N400, ")"),
      dark: "var(--ds-text-subtlest, ".concat(colors.B75, ")")
    })(akTheme),
    punctuationColor: themed({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    propertyColor: themed({
      light: "var(--ds-text-accent-purple, ".concat(colors.P300, ")"),
      dark: "var(--ds-text-accent-purple, ".concat(colors.P75, ")")
    })(akTheme),
    constantColor: themed({
      light: "var(--ds-text-accent-teal, ".concat(T800, ")"),
      dark: "var(--ds-text-accent-teal, ".concat(colors.T100, ")")
    })(akTheme),
    booleanColor: themed({
      light: "var(--ds-text-accent-blue, ".concat(colors.B400, ")"),
      dark: "var(--ds-text-accent-blue, ".concat(colors.B75, ")")
    })(akTheme),
    charColor: themed({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.DN800, ")")
    })(akTheme),
    insertedColor: themed({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.B75, ")")
    })(akTheme),
    deletedColor: themed({
      light: "var(--ds-text-accent-red, ".concat(colors.R500, ")"),
      dark: "var(--ds-text-accent-red, ".concat(colors.B75, ")")
    })(akTheme),
    operatorColor: themed({
      light: "var(--ds-text, ".concat(colors.N800, ")"),
      dark: "var(--ds-text, ".concat(colors.B75, ")")
    })(akTheme),
    atruleColor: themed({
      light: "var(--ds-text-accent-green, ".concat(colors.G500, ")"),
      dark: "var(--ds-text-accent-green, ".concat(colors.G200, ")")
    })(akTheme),
    importantColor: themed({
      light: "var(--ds-text-accent-yellow, ".concat(Y1100, ")"),
      dark: "var(--ds-text-accent-yellow, ".concat(colors.Y300, ")")
    })(akTheme)
  };
});
var getTheme = function getTheme(theme) {
  return _objectSpread(_objectSpread({}, getBaseTheme(theme)), getColorPalette(theme));
};
export default getTheme;