import memoizeOne from 'memoize-one';
import { SUPPORTED_LANGUAGES } from '../../constants';
export var normalizeLanguage = memoizeOne(function (language) {
  if (!language) {
    return '';
  }
  var match = SUPPORTED_LANGUAGES.find(function (val) {
    return val.name === language || val.alias.includes(language);
  });
  // Fallback to plain monospaced text if language passed but not supported
  return match ? match.value : 'text';
});