import createLineElement from './create-line-element';
import getInlineLineNumber from './get-inline-line-number';
function createLineGenerator(lineProps, shouldCreateParentElementForLines, showLineNumbers) {
  return function (children, lineNumber) {
    var className = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    // Needed for more complex line creation
    if (shouldCreateParentElementForLines || className.length > 0) {
      return createLineElement({
        children: children,
        lineNumber: lineNumber,
        showLineNumbers: showLineNumbers,
        lineProps: lineProps,
        className: className
      });
    } else {
      // Simple line creation without the bells and whistles
      if (showLineNumbers && lineNumber) {
        children.unshift(getInlineLineNumber(lineNumber));
      }
      return children;
    }
  };
}
export default createLineGenerator;