import createLineElement from './create-line-element';
export default function flattenCodeTree(tree) {
  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var className = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
  var newTree = [];
  for (var i = 0; i < tree.length; i++) {
    var node = tree[i];
    if (node.type === 'text') {
      newTree.push(createLineElement({
        children: [node],
        lineNumber: offset,
        className: className
      }));
    } else if (node.children) {
      var classNames = className.concat(node.properties.className || []);
      flattenCodeTree(node.children, offset + 1, classNames).forEach(function (i) {
        return newTree.push(i);
      });
    }
  }
  return newTree;
}