import createLineGenerator from './create-line';
import createLineElement from './create-line-element';
import flattenCodeTree from './flatten-code-tree';
import getCodeTree from './get-code-tree';
var newLineRegex = /\n/g;
function getNewLines(str) {
  return str.match(newLineRegex);
}
/**
 * __Line Processor__
 *
 * A line processor, that uses refractor to turn code into a tree structure
 * with highlighting metadata and collapses this tree into lines for a renderer.
 */
export default function processLines(_ref) {
  var astGenerator = _ref.astGenerator,
    code = _ref.code,
    language = _ref.language,
    shouldCreateParentElementForLines = _ref.shouldCreateParentElementForLines,
    lineProps = _ref.lineProps,
    showLineNumbers = _ref.showLineNumbers;
  var codeTree = getCodeTree(language, code, astGenerator);
  var startingLineNumber = 1;
  var createLine = createLineGenerator(lineProps, shouldCreateParentElementForLines, showLineNumbers);
  var newTree = [];
  var lastLineBreakIndex = -1;
  var index = 0;

  // Seems odd we flatten the tree immediately - what work could we do on it more performantly than on the lines?
  var tree = flattenCodeTree(codeTree);
  var _loop = function _loop() {
    var testNode = tree[index];
    if (testNode.type === 'text') {
      index++;
      return "continue";
    }
    var node = testNode;
    var firstChildNode = node.children[0];
    if (firstChildNode.type === 'text') {
      var value = firstChildNode.value;
      var newLines = getNewLines(value);
      if (newLines) {
        var splitValue = value.split('\n');
        splitValue.forEach(function (text, i) {
          var lineNumber = newTree.length + startingLineNumber;
          var newChild = {
            type: 'text',
            value: "".concat(text, "\n")
          };

          // if it's the first line
          if (i === 0) {
            var _children = tree.slice(lastLineBreakIndex + 1, index).concat(createLineElement({
              children: [newChild],
              className: node.properties.className,
              lineNumber: lineNumber
            }));
            var _line = createLine(_children, lineNumber);
            newTree.push(_line);

            // if it's the last line
          } else if (i === splitValue.length - 1) {
            var nextNode = tree[index + 1];
            var stringChild = nextNode && nextNode.children && nextNode.children[0];
            // Similar to newChild above, but no newline
            var lastLineInPreviousSpan = {
              type: 'text',
              value: "".concat(text)
            };
            if (stringChild) {
              var newElem = createLineElement({
                children: [lastLineInPreviousSpan],
                className: node.properties.className,
                lineNumber: lineNumber
              });
              tree.splice(index + 1, 0, newElem);
            } else {
              var _children2 = [lastLineInPreviousSpan];
              var _line2 = createLine(_children2, lineNumber, node.properties.className);
              newTree.push(_line2);
            }

            // if it's neither the first nor the last line
          } else {
            var _children3 = [newChild];
            var _line3 = createLine(_children3, lineNumber, node.properties.className);
            newTree.push(_line3);
          }
        });
        lastLineBreakIndex = index;
      }
    }
    index++;
  };
  while (index < tree.length) {
    var _ret = _loop();
    if (_ret === "continue") continue;
  }
  if (lastLineBreakIndex !== tree.length - 1) {
    var children = tree.slice(lastLineBreakIndex + 1, tree.length);
    if (children && children.length) {
      var lineNumber = newTree.length + startingLineNumber;
      var line = createLine(children, lineNumber);
      newTree.push(line);
    }
  }
  if (shouldCreateParentElementForLines) {
    return newTree;
  }

  // If shouldCreateParentElementForLines was off, we still have a tree structure we need to flatten
  // We have (RefractorNode | RefractorNode[])[] but need RefractorNode[]
  // This seems like a code smell to review
  return newTree.flat(1);
}