import createElement from './create-element';
export default function createChildren(codeBidiWarningConfig) {
  var childrenCount = 0;
  return function (children) {
    childrenCount += 1;
    return children.map(function (child, i) {
      return createElement({
        node: child,
        codeBidiWarningConfig: codeBidiWarningConfig,
        key: "code-segment-".concat(childrenCount, "-").concat(i)
      });
    });
  };
}