import React from 'react';
import createElement from './create-element';

/**
 * __React Renderer__
 *
 * A component that receives processed code lines and renders them into the code
 * rows inside the wrapping span and nested code tag, applying passed props and
 * code bidi warning config settings.
 */
export default function ReactRenderer(_ref) {
  var containerProps = _ref.containerProps,
    codeTagProps = _ref.codeTagProps,
    rows = _ref.rows,
    codeBidiWarningConfig = _ref.codeBidiWarningConfig;
  var renderedRows = rows.map(function (node, i) {
    return createElement({
      node: node,
      codeBidiWarningConfig: codeBidiWarningConfig,
      key: "code-segment".concat(i)
    });
  });
  return /*#__PURE__*/React.createElement("span", containerProps, /*#__PURE__*/React.createElement("code", codeTagProps, renderedRows));
}