import type { CSSObject } from '@emotion/react';
import type { Theme } from '@atlaskit/theme/types';
import type { CodeBlockTheme, CodeTheme } from './types';
export declare const getLineNumWidth: (numLines: number) => string;
/**
 * Styles applied at the root element level, common across code/codeblock
 */
export declare const getBaseCodeStyles: (theme: CodeTheme) => {
    fontSize: number;
    fontFamily: string | undefined;
    fontWeight: string;
    backgroundColor: string;
    color: string | undefined;
    borderStyle: string;
    borderRadius: string;
};
/**
 * Takes an implemented CodeBlock theme, and returns styles required for
 * react-syntax-highlighter.
 *
 * @param theme
 */
export declare const getCodeBlockStyles: (theme: CodeBlockTheme) => (highlightedStartText: string, highlightedEndText: string, showLineNumbers: boolean, shouldWrapLongLines: boolean) => CSSObject;
export declare const getCodeStyles: (globalTheme: Theme | {
    theme: Theme;
}) => CSSObject;
export declare const getCodeBlockTheme: (globalTheme: Theme, maxLines?: number) => CodeBlockTheme;
