import { AstGenerator, RefractorNode, SyntaxHighlighterLineProps } from '../../types';
interface ProcessLines {
    astGenerator: AstGenerator;
    code: string;
    language: string;
    shouldCreateParentElementForLines: boolean;
    lineProps: SyntaxHighlighterLineProps;
    showLineNumbers: boolean;
}
/**
 * __Line Processor__
 *
 * A line processor, that uses refractor to turn code into a tree structure
 * with highlighting metadata and collapses this tree into lines for a renderer.
 */
export default function processLines({ astGenerator, code, language, shouldCreateParentElementForLines, lineProps, showLineNumbers, }: ProcessLines): RefractorNode[];
export {};
