"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DatePickerWithoutAnalytics = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _dateFns = require("date-fns");
var _pick = _interopRequireDefault(require("lodash/pick"));
var _analyticsNext = require("@atlaskit/analytics-next");
var _calendar = _interopRequireDefault(require("@atlaskit/calendar"));
var _calendar2 = _interopRequireDefault(require("@atlaskit/icon/glyph/calendar"));
var _locale = require("@atlaskit/locale");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _select = _interopRequireWildcard(require("@atlaskit/select"));
var _colors = require("@atlaskit/theme/colors");
var _constants = require("@atlaskit/theme/constants");
var _internal = require("../internal");
var _fixedLayer = _interopRequireDefault(require("../internal/fixed-layer"));
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } } /* eslint-disable @repo/internal/react/use-noop */ /** @jsx jsx */ // eslint-disable-next-line no-restricted-imports
var packageName = "@atlaskit/datetime-picker";
var packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

function getValidDate(iso) {
  var date = (0, _dateFns.parseISO)(iso);
  return (0, _dateFns.isValid)(date) ? {
    day: date.getDate(),
    month: date.getMonth() + 1,
    year: date.getFullYear()
  } : {};
}
function getShortISOString(date) {
  return (0, _dateFns.format)(date, (0, _utils.convertTokens)('YYYY-MM-DD'));
}
var menuStyles = (0, _react2.css)({
  zIndex: _constants.layers.dialog(),
  backgroundColor: "var(--ds-surface-overlay, ".concat(_colors.N0, ")"),
  borderRadius: "var(--ds-border-radius, 3px)",
  boxShadow: "var(--ds-shadow-overlay, ".concat("0 4px 8px -2px ".concat(_colors.N50A, ", 0 0 1px ").concat(_colors.N60A), ")"),
  overflow: 'hidden'
});
var Menu = function Menu(_ref) {
  var selectProps = _ref.selectProps,
    innerProps = _ref.innerProps;
  return (0, _react2.jsx)(_fixedLayer.default, {
    inputValue: selectProps.inputValue,
    containerRef: selectProps.calendarContainerRef,
    content: (0, _react2.jsx)("div", (0, _extends2.default)({
      css: menuStyles
    }, innerProps), (0, _react2.jsx)(_calendar.default, (0, _extends2.default)({}, getValidDate(selectProps.calendarValue), getValidDate(selectProps.calendarView), {
      disabled: selectProps.calendarDisabled,
      disabledDateFilter: selectProps.calendarDisabledDateFilter,
      minDate: selectProps.calendarMinDate,
      maxDate: selectProps.calendarMaxDate,
      nextMonthLabel: selectProps.nextMonthLabel,
      onChange: selectProps.onCalendarChange,
      onSelect: selectProps.onCalendarSelect,
      previousMonthLabel: selectProps.previousMonthLabel,
      calendarRef: selectProps.calendarRef,
      selected: [selectProps.calendarValue],
      locale: selectProps.calendarLocale,
      testId: selectProps.testId && "".concat(selectProps.testId, "--calendar"),
      weekStartDay: selectProps.calendarWeekStartDay,
      tabIndex: -1
    }))),
    testId: selectProps.testId
  });
};
var datePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  defaultIsOpen: false,
  defaultValue: '',
  disabled: [],
  disabledDateFilter: function disabledDateFilter(_) {
    return false;
  },
  hideIcon: false,
  icon: _calendar2.default,
  id: '',
  innerProps: {},
  isDisabled: false,
  isInvalid: false,
  name: '',
  onBlur: function onBlur(event) {},
  onChange: function onChange(value) {},
  onFocus: function onFocus(event) {},
  selectProps: {},
  spacing: 'default',
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};
var DatePicker = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(DatePicker, _Component);
  var _super = _createSuper(DatePicker);
  function DatePicker(props) {
    var _this;
    (0, _classCallCheck2.default)(this, DatePicker);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "calendarRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "containerRef", null);
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSafeState", function () {
      return _objectSpread(_objectSpread(_objectSpread({}, _this.state), (0, _pick.default)(_this.props, ['value', 'isOpen'])), (0, _pick.default)(_this.props.selectProps, ['inputValue']));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "isDateDisabled", function (date) {
      return _this.props.disabled.indexOf(date) > -1;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCalendarChange", function (_ref2) {
      var iso = _ref2.iso;
      var _iso$split = iso.split('-'),
        _iso$split2 = (0, _slicedToArray2.default)(_iso$split, 3),
        year = _iso$split2[0],
        month = _iso$split2[1],
        date = _iso$split2[2];
      var newIso = iso;
      var parsedDate = parseInt(date, 10);
      var parsedMonth = parseInt(month, 10);
      var parsedYear = parseInt(year, 10);
      var lastDayInMonth = (0, _dateFns.lastDayOfMonth)(new Date(parsedYear, parsedMonth - 1) // This needs to be -1, because the Date constructor expects an index of the given month
      ).getDate();
      if (lastDayInMonth < parsedDate) {
        newIso = "".concat(year, "-").concat((0, _internal.padToTwo)(parsedMonth), "-").concat((0, _internal.padToTwo)(lastDayInMonth));
      } else {
        newIso = "".concat(year, "-").concat((0, _internal.padToTwo)(parsedMonth), "-").concat((0, _internal.padToTwo)(parsedDate));
      }
      _this.setState({
        calendarValue: newIso
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCalendarSelect", function (_ref3) {
      var iso = _ref3.iso;
      _this.setState({
        selectInputValue: '',
        isOpen: false,
        calendarValue: iso,
        value: iso
      });
      _this.props.onChange(iso);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onInputClick", function () {
      if (!_this.props.isDisabled && !_this.getSafeState().isOpen) {
        _this.setState({
          isOpen: true
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectBlur", function (event) {
      if (_this.getSafeState().clearingFromIcon) {
        // Don't close menu if blurring after the user has clicked clear
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: false,
          isFocused: false
        });
      }
      _this.props.onBlur(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectFocus", function (event) {
      var _this$getSafeState = _this.getSafeState(),
        clearingFromIcon = _this$getSafeState.clearingFromIcon,
        value = _this$getSafeState.value;
      if (clearingFromIcon) {
        // Don't open menu if focussing after the user has clicked clear
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: true,
          calendarValue: value,
          isFocused: true
        });
      }
      _this.props.onFocus(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onTextInput", function (event) {
      var value = event.target.value;
      if (value) {
        var parsed = _this.parseDate(value);
        // Only try to set the date if we have month & day
        if (parsed && (0, _dateFns.isValid)(parsed)) {
          // We format the parsed date to YYYY-MM-DD here because
          // this is the format expected by the @atlaskit/calendar component
          _this.setState({
            calendarValue: getShortISOString(parsed)
          });
        }
      }
      _this.setState({
        isOpen: true
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSafeCalendarValue", function (calendarValue) {
      // If `calendarValue` has a year that is greater than 9999, default to
      // today's date
      var yearIsOverLimit = calendarValue.match(/^\d{5,}/);
      if (yearIsOverLimit) {
        return getShortISOString(new Date());
      }
      return calendarValue;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onInputKeyDown", function (event) {
      var _this$getSafeState2 = _this.getSafeState(),
        value = _this$getSafeState2.value,
        calendarValue = _this$getSafeState2.calendarValue;
      var keyPressed = event.key.toLowerCase();
      switch (keyPressed) {
        case 'arrowup':
        case 'arrowdown':
          if (_this.calendarRef) {
            event.preventDefault();
            var key = keyPressed === 'arrowup' ? 'up' : 'down';
            _this.calendarRef.navigate(key);
          }
          _this.setState({
            isOpen: true
          });
          break;
        case 'arrowleft':
        case 'arrowright':
          if (_this.calendarRef) {
            event.preventDefault();
            var _key = keyPressed === 'arrowleft' ? 'left' : 'right';
            _this.calendarRef.navigate(_key);
          }
          break;
        case 'escape':
        case 'tab':
          _this.setState({
            isOpen: false
          });
          break;
        case 'backspace':
        case 'delete':
          {
            var inputCount = (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.date-picker-input-a11y-fix_cbbxs') ? 1 : 0;
            if (value && event.target instanceof HTMLInputElement && event.target.value.length <= inputCount) {
              // If being cleared from keyboard, don't change behaviour
              _this.setState({
                clearingFromIcon: false,
                value: ''
              });
            }
            break;
          }
        case 'enter':
          if (!_this.state.isOpen) {
            return;
          }
          // Prevent form submission when a date is selected
          // using enter. See https://product-fabric.atlassian.net/browse/DSP-2501
          // for more details.
          event.preventDefault();
          if (!_this.isDateDisabled(calendarValue)) {
            var _this$getSafeState3 = _this.getSafeState(),
              _value = _this$getSafeState3.value;
            // Get a safe `calendarValue` in case the value exceeds the maximum
            // allowed by ISO 8601
            var safeCalendarValue = _this.getSafeCalendarValue(calendarValue);
            var valueChanged = safeCalendarValue !== _value;
            _this.setState({
              selectInputValue: '',
              isOpen: false,
              value: safeCalendarValue,
              calendarValue: safeCalendarValue
            });
            if (valueChanged) {
              _this.props.onChange(safeCalendarValue);
            }
          }
          break;
        default:
          break;
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClear", function () {
      var changedState = {
        value: '',
        calendarValue: _this.props.defaultValue || getShortISOString(new Date())
      };
      if (!_this.props.hideIcon) {
        changedState = _objectSpread(_objectSpread({}, changedState), {}, {
          clearingFromIcon: true
        });
      }
      _this.setState(changedState);
      _this.props.onChange('');
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectChange", function (value, action) {
      // Used for native clear event in React Select
      // Triggered when clicking ClearIndicator or backspace with no value
      if (action.action === 'clear') {
        _this.onClear();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "refCalendar", function (ref) {
      _this.calendarRef = ref;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSelectInputChange", function (selectInputValue, actionMeta) {
      var onInputChange = _this.props.selectProps.onInputChange;
      if (onInputChange) {
        onInputChange(selectInputValue, actionMeta);
      }
      _this.setState({
        selectInputValue: selectInputValue
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getContainerRef", function (ref) {
      var oldRef = _this.containerRef;
      _this.containerRef = ref;
      // Cause a re-render if we're getting the container ref for the first time
      // as the layered menu requires it for dimension calculation
      if (oldRef == null && ref != null) {
        _this.forceUpdate();
      }
    });
    /**
     * There are two props that can change how the date is parsed.
     * The priority of props used is:
     *   1. parseInputValue
     *   2. locale
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "parseDate", function (date) {
      var _this$props = _this.props,
        parseInputValue = _this$props.parseInputValue,
        dateFormat = _this$props.dateFormat;
      if (parseInputValue) {
        return parseInputValue(date, dateFormat || _internal.defaultDateFormat);
      }
      var _this$getSafeState4 = _this.getSafeState(),
        l10n = _this$getSafeState4.l10n;
      return l10n.parseDate(date);
    });
    /**
     * There are multiple props that can change how the date is formatted.
     * The priority of props used is:
     *   1. formatDisplayLabel
     *   2. dateFormat
     *   3. locale
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "formatDate", function (value) {
      var _this$props2 = _this.props,
        formatDisplayLabel = _this$props2.formatDisplayLabel,
        dateFormat = _this$props2.dateFormat;
      var _this$getSafeState5 = _this.getSafeState(),
        l10n = _this$getSafeState5.l10n;
      if (formatDisplayLabel) {
        return formatDisplayLabel(value, dateFormat || _internal.defaultDateFormat);
      }
      var date = (0, _dateFns.parseISO)(value);
      return dateFormat ? (0, _dateFns.format)(date, (0, _utils.convertTokens)(dateFormat)) : l10n.formatDate(date);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getPlaceholder", function () {
      var placeholder = _this.props.placeholder;
      if (placeholder) {
        return placeholder;
      }
      var _this$getSafeState6 = _this.getSafeState(),
        l10n = _this$getSafeState6.l10n;
      return l10n.formatDate(_internal.placeholderDatetime);
    });
    _this.state = {
      isOpen: _this.props.defaultIsOpen,
      isFocused: false,
      clearingFromIcon: false,
      selectInputValue: _this.props.selectProps.inputValue,
      value: _this.props.value || _this.props.defaultValue,
      calendarValue: _this.props.value || _this.props.defaultValue || getShortISOString(new Date()),
      l10n: (0, _locale.createLocalizationProvider)(_this.props.locale)
    };
    return _this;
  }
  (0, _createClass2.default)(DatePicker, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      if (this.props.locale !== nextProps.locale) {
        this.setState({
          l10n: (0, _locale.createLocalizationProvider)(nextProps.locale)
        });
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props3 = this.props,
        appearance = _this$props3.appearance,
        autoFocus = _this$props3.autoFocus,
        disabled = _this$props3.disabled,
        hideIcon = _this$props3.hideIcon,
        icon = _this$props3.icon,
        id = _this$props3.id,
        innerProps = _this$props3.innerProps,
        isDisabled = _this$props3.isDisabled,
        disabledDateFilter = _this$props3.disabledDateFilter,
        maxDate = _this$props3.maxDate,
        minDate = _this$props3.minDate,
        isInvalid = _this$props3.isInvalid,
        name = _this$props3.name,
        nextMonthLabel = _this$props3.nextMonthLabel,
        previousMonthLabel = _this$props3.previousMonthLabel,
        selectProps = _this$props3.selectProps,
        spacing = _this$props3.spacing,
        locale = _this$props3.locale,
        testId = _this$props3.testId,
        weekStartDay = _this$props3.weekStartDay;
      var _this$getSafeState7 = this.getSafeState(),
        value = _this$getSafeState7.value,
        calendarValue = _this$getSafeState7.calendarValue,
        isOpen = _this$getSafeState7.isOpen,
        selectInputValue = _this$getSafeState7.selectInputValue;
      var actualSelectInputValue;
      if ((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.date-picker-input-a11y-fix_cbbxs')) {
        actualSelectInputValue = selectInputValue || (value ? this.formatDate(value) : undefined);
      } else {
        actualSelectInputValue = selectInputValue;
      }
      var menuIsOpen = isOpen && !isDisabled;
      var showClearIndicator = Boolean((value || selectInputValue) && !hideIcon);
      var dropDownIcon = appearance === 'subtle' || hideIcon || showClearIndicator ? null : icon;
      var selectComponents = _objectSpread({
        DropdownIndicator: dropDownIcon,
        Menu: Menu
      }, !showClearIndicator && {
        ClearIndicator: _internal.EmptyComponent
      });
      var _selectProps$styles = selectProps.styles,
        selectStyles = _selectProps$styles === void 0 ? {} : _selectProps$styles;
      var disabledStyle = isDisabled ? {
        pointerEvents: 'none',
        color: "var(--ds-icon-disabled, inherit)"
      } : {};
      var calendarProps = {
        calendarContainerRef: this.containerRef,
        calendarRef: this.refCalendar,
        calendarDisabled: disabled,
        calendarDisabledDateFilter: disabledDateFilter,
        calendarMaxDate: maxDate,
        calendarMinDate: minDate,
        calendarValue: value && getShortISOString((0, _dateFns.parseISO)(value)),
        calendarView: calendarValue,
        onCalendarChange: this.onCalendarChange,
        onCalendarSelect: this.onCalendarSelect,
        calendarLocale: locale,
        calendarWeekStartDay: weekStartDay,
        nextMonthLabel: nextMonthLabel,
        previousMonthLabel: previousMonthLabel
      };
      return (
        // TODO: Remove role="presentation", since div's have no semantics anyway
        // (DSP-11587)
        (0, _react2.jsx)("div", (0, _extends2.default)({}, innerProps, {
          role: "presentation",
          onClick: this.onInputClick,
          onInput: this.onTextInput,
          onKeyDown: this.onInputKeyDown,
          ref: this.getContainerRef,
          "data-testid": testId && "".concat(testId, "--container")
        }), (0, _react2.jsx)("input", {
          name: name,
          type: "hidden",
          value: value,
          "data-testid": testId && "".concat(testId, "--input")
        }), (0, _react2.jsx)(_select.default, (0, _extends2.default)({
          appearance: this.props.appearance,
          enableAnimation: false,
          menuIsOpen: menuIsOpen,
          closeMenuOnSelect: true,
          autoFocus: autoFocus,
          instanceId: id,
          isDisabled: isDisabled,
          onBlur: this.onSelectBlur,
          onFocus: this.onSelectFocus,
          inputValue: actualSelectInputValue,
          onInputChange: this.handleSelectInputChange,
          components: selectComponents,
          onChange: this.onSelectChange,
          styles: (0, _select.mergeStyles)(selectStyles, {
            control: function control(base) {
              return _objectSpread(_objectSpread({}, base), disabledStyle);
            },
            indicatorsContainer: function indicatorsContainer(base) {
              return _objectSpread(_objectSpread({}, base), {}, {
                paddingLeft: "var(--ds-space-025, 2px)",
                // ICON_PADDING = 2
                paddingRight: "var(--ds-space-075, 6px)" // 8 - ICON_PADDING = 6
              });
            }
          }),

          placeholder: this.getPlaceholder(),
          value: value && {
            label: this.formatDate(value),
            value: value
          }
        }, selectProps, calendarProps, {
          isClearable: true,
          spacing: spacing,
          isInvalid: isInvalid,
          testId: testId
        })))
      );
    }
  }]);
  return DatePicker;
}(_react.Component);
exports.DatePickerWithoutAnalytics = DatePicker;
(0, _defineProperty2.default)(DatePicker, "defaultProps", datePickerDefaultProps);
var _default = (0, _analyticsNext.withAnalyticsContext)({
  componentName: 'datePicker',
  packageName: packageName,
  packageVersion: packageVersion
})((0, _analyticsNext.withAnalyticsEvents)({
  onChange: (0, _analyticsNext.createAndFireEvent)('atlaskit')({
    action: 'selectedDate',
    actionSubject: 'datePicker',
    attributes: {
      componentName: 'datePicker',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(DatePicker));
exports.default = _default;