"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.timePickerDefaultAriaLabel = exports.default = exports.datePickerDefaultAriaLabel = exports.DateTimePickerWithoutAnalytics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _dateFns = require("date-fns");
var _pick = _interopRequireDefault(require("lodash/pick"));
var _analyticsNext = require("@atlaskit/analytics-next");
var _selectClear = _interopRequireDefault(require("@atlaskit/icon/glyph/select-clear"));
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _select = require("@atlaskit/select");
var _colors = require("@atlaskit/theme/colors");
var _internal = require("../internal");
var _datePicker = _interopRequireDefault(require("./date-picker"));
var _timePicker = _interopRequireDefault(require("./time-picker"));
var _utils = require("./utils");
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; } /* eslint-disable @repo/internal/react/use-noop */ /** @jsx jsx */ // eslint-disable-next-line no-restricted-imports
var packageName = "@atlaskit/datetime-picker";
var packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

var isInvalidBorderStyles = (0, _react2.css)({
  borderColor: "var(--ds-border-danger, ".concat(_colors.R400, ")")
});
var isFocusedBorderStyles = (0, _react2.css)({
  borderColor: "var(--ds-border-focused, ".concat(_colors.B100, ")")
});
var isFocusedStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-input-pressed, ".concat(_colors.N0, ")")
});
var subtleBgStyles = (0, _react2.css)({
  backgroundColor: 'transparent',
  borderColor: 'transparent'
});
var subtleFocusedBgStyles = (0, _react2.css)({
  backgroundColor: "var(--ds-background-input-pressed, transparent)",
  borderColor: 'transparent'
});
var noBgStyles = (0, _react2.css)({
  backgroundColor: 'transparent',
  borderColor: 'transparent',
  '&:hover': {
    backgroundColor: 'transparent',
    borderColor: 'transparent'
  }
});
var hoverStyles = (0, _react2.css)({
  '&:hover': {
    backgroundColor: "var(--ds-background-input-hovered, ".concat(_colors.N30, ")"),
    borderColor: "var(--ds-border-input, ".concat((0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? _colors.N100 : _colors.N30, ")")
  }
});
var isInvalidHoverStyles = (0, _react2.css)({
  '&:hover': {
    backgroundColor: "var(--ds-background-input-hovered, ".concat(_colors.N0, ")"),
    borderColor: "var(--ds-border-danger, ".concat(_colors.R400, ")")
  }
});
var isDisabledStyles = (0, _react2.css)({
  '&:hover': {
    cursor: 'default'
  }
});
var baseContainerStyles = (0, _react2.css)({
  display: 'flex',
  backgroundColor: "var(--ds-background-input, ".concat(_colors.N20, ")"),
  border: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.border-checkbox_nyoiu') ? "var(--ds-border-width, 1px)".concat(" solid ", "var(--ds-border-input, ".concat(_colors.N100, ")")) : "2px solid ".concat("var(--ds-border-input, ".concat(_colors.N20, ")")),
  borderRadius: "var(--ds-border-radius, 3px)",
  transition: 'background-color 200ms ease-in-out, border-color 200ms ease-in-out',
  '&:hover': {
    cursor: 'pointer'
  }
});

// Make DatePicker 50% the width of DateTimePicker
// If rendering an icon container, shrink the TimePicker
var datePickerContainerStyles = (0, _react2.css)({
  flexBasis: '50%',
  flexGrow: 1,
  flexShrink: 0
});
var timePickerContainerStyles = (0, _react2.css)({
  flexBasis: '50%',
  flexGrow: 1
});
var iconContainerStyles = (0, _react2.css)({
  display: 'flex',
  paddingTop: "var(--ds-space-075, 6px)",
  paddingRight: "var(--ds-space-100, 8px)",
  paddingBottom: "var(--ds-space-075, 6px)",
  paddingLeft: "var(--ds-space-050, 4px)",
  // ICON_PADDING (2) * 2
  alignItems: 'center',
  flexBasis: 'inherit',
  backgroundColor: 'inherit',
  border: 'none',
  color: "var(--ds-text-subtlest, ".concat(_colors.N70, ")"),
  transition: "color 150ms",
  '&:hover': {
    color: "var(--ds-text-subtle, ".concat(_colors.N500, ")")
  }
});

// react-select overrides (via @atlaskit/select).
var styles = {
  control: function control(style) {
    return _objectSpread(_objectSpread({}, style), {}, {
      backgroundColor: 'transparent',
      border: 2,
      borderRadius: 0,
      paddingLeft: 0,
      ':hover': {
        backgroundColor: 'transparent',
        cursor: 'inherit'
      }
    });
  }
};
var dateTimePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  isDisabled: false,
  name: '',
  onBlur: function onBlur(event) {},
  onChange: function onChange(value) {},
  onFocus: function onFocus(event) {},
  innerProps: {},
  id: '',
  defaultValue: '',
  timeIsEditable: false,
  isInvalid: false,
  datePickerProps: {},
  timePickerProps: {},
  datePickerSelectProps: {},
  timePickerSelectProps: {},
  times: _internal.defaultTimes,
  spacing: 'default',
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};

var datePickerDefaultAriaLabel = 'Date';
exports.datePickerDefaultAriaLabel = datePickerDefaultAriaLabel;
var timePickerDefaultAriaLabel = 'Time';
exports.timePickerDefaultAriaLabel = timePickerDefaultAriaLabel;
var DateTimePicker = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(DateTimePicker, _React$Component);
  var _super = _createSuper(DateTimePicker);
  function DateTimePicker() {
    var _this;
    (0, _classCallCheck2.default)(this, DateTimePicker);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      active: 0,
      dateValue: '',
      isFocused: false,
      timeValue: '',
      value: _this.props.defaultValue,
      zoneValue: ''
    });
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSafeState", function () {
      var mappedState = _objectSpread(_objectSpread({}, _this.state), (0, _pick.default)(_this.props, ['value']));
      return _objectSpread(_objectSpread({}, mappedState), _this.parseValue(mappedState.value, mappedState.dateValue, mappedState.timeValue, mappedState.zoneValue));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function (event) {
      _this.setState({
        isFocused: false
      });
      _this.props.onBlur(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (event) {
      _this.setState({
        isFocused: true
      });
      _this.props.onFocus(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onDateChange", function (dateValue) {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        dateValue: dateValue
      }));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onTimeChange", function (timeValue) {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        timeValue: timeValue
      }));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onClear", function () {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        timeValue: '',
        dateValue: ''
      }));
    });
    return _this;
  }
  (0, _createClass2.default)(DateTimePicker, [{
    key: "parseValue",
    value: function parseValue(value, dateValue, timeValue, zoneValue) {
      if (this.props.parseValue) {
        return this.props.parseValue(value, dateValue, timeValue, zoneValue);
      }
      var parsed = (0, _dateFns.parseISO)(value);
      return (0, _dateFns.isValid)(parsed) ? {
        dateValue: (0, _dateFns.format)(parsed, (0, _utils.convertTokens)('YYYY-MM-DD')),
        timeValue: (0, _dateFns.format)(parsed, (0, _utils.convertTokens)('HH:mm')),
        zoneValue: (0, _dateFns.format)(parsed, (0, _utils.convertTokens)('ZZ'))
      } : {
        dateValue: dateValue,
        timeValue: timeValue,
        zoneValue: zoneValue
      };
    }
  }, {
    key: "onValueChange",
    value: function onValueChange(_ref) {
      var dateValue = _ref.dateValue,
        timeValue = _ref.timeValue,
        zoneValue = _ref.zoneValue;
      this.setState({
        dateValue: dateValue,
        timeValue: timeValue,
        zoneValue: zoneValue
      });
      if (dateValue && timeValue) {
        var _value = (0, _internal.formatDateTimeZoneIntoIso)(dateValue, timeValue, zoneValue);
        var _this$parseValue = this.parseValue(_value, dateValue, timeValue, zoneValue),
          parsedZone = _this$parseValue.zoneValue;
        var valueWithValidZone = (0, _internal.formatDateTimeZoneIntoIso)(dateValue, timeValue, parsedZone);
        this.setState({
          value: valueWithValidZone
        });
        this.props.onChange(valueWithValidZone);
        // If the date or time value was cleared when there is an existing datetime value, then clear the value.
      } else if (this.getSafeState().value) {
        this.setState({
          value: ''
        });
        this.props.onChange('');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        autoFocus = _this$props.autoFocus,
        id = _this$props.id,
        innerProps = _this$props.innerProps,
        isDisabled = _this$props.isDisabled,
        name = _this$props.name,
        timeIsEditable = _this$props.timeIsEditable,
        dateFormat = _this$props.dateFormat,
        datePickerProps = _this$props.datePickerProps,
        datePickerSelectProps = _this$props.datePickerSelectProps,
        timePickerProps = _this$props.timePickerProps,
        timePickerSelectProps = _this$props.timePickerSelectProps,
        times = _this$props.times,
        timeFormat = _this$props.timeFormat,
        locale = _this$props.locale,
        testId = _this$props.testId;
      var _this$getSafeState = this.getSafeState(),
        isFocused = _this$getSafeState.isFocused,
        value = _this$getSafeState.value,
        dateValue = _this$getSafeState.dateValue,
        timeValue = _this$getSafeState.timeValue;
      var bothProps = {
        isDisabled: isDisabled,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        isInvalid: this.props.isInvalid,
        appearance: this.props.appearance,
        spacing: this.props.spacing
      };
      var _datePickerSelectProp = datePickerSelectProps.styles,
        datePickerStyles = _datePickerSelectProp === void 0 ? {} : _datePickerSelectProp;
      var _timePickerSelectProp = timePickerSelectProps.styles,
        timePickerStyles = _timePickerSelectProp === void 0 ? {} : _timePickerSelectProp;
      var mergedDatePickerSelectProps = _objectSpread(_objectSpread({}, datePickerSelectProps), {}, {
        'aria-label': datePickerSelectProps['aria-label'] || datePickerDefaultAriaLabel,
        styles: (0, _select.mergeStyles)(styles, datePickerStyles)
      });
      var mergedTimePickerSelectProps = _objectSpread(_objectSpread({}, timePickerSelectProps), {}, {
        'aria-label': timePickerSelectProps['aria-label'] || timePickerDefaultAriaLabel,
        styles: (0, _select.mergeStyles)(styles, timePickerStyles)
      });

      // Render DateTimePicker's IconContainer when a value has been filled
      // Don't use Date or TimePicker's because they can't be customised
      var isClearable = Boolean(dateValue || timeValue);
      var notFocusedOrIsDisabled = !(isFocused || isDisabled);
      return (0, _react2.jsx)("div", (0, _extends2.default)({
        css: [baseContainerStyles, isDisabled && isDisabledStyles, isFocused && isFocusedStyles, bothProps.appearance === 'subtle' && (isFocused ? subtleFocusedBgStyles : subtleBgStyles), isFocused && isFocusedBorderStyles, bothProps.isInvalid && isInvalidBorderStyles, notFocusedOrIsDisabled && (bothProps.isInvalid ? isInvalidHoverStyles : hoverStyles), bothProps.appearance === 'none' && noBgStyles]
      }, innerProps, {
        "data-testid": testId
      }), (0, _react2.jsx)("input", {
        name: name,
        type: "hidden",
        value: value,
        "data-testid": testId && "".concat(testId, "--input")
      }), (0, _react2.jsx)("div", {
        css: datePickerContainerStyles
      }, (0, _react2.jsx)(_datePicker.default, (0, _extends2.default)({}, bothProps, {
        autoFocus: autoFocus,
        dateFormat: dateFormat,
        hideIcon: true,
        id: id,
        onChange: this.onDateChange,
        selectProps: mergedDatePickerSelectProps,
        value: dateValue,
        locale: locale,
        testId: testId && "".concat(testId, "--datepicker")
      }, datePickerProps))), (0, _react2.jsx)("div", {
        css: timePickerContainerStyles
      }, (0, _react2.jsx)(_timePicker.default, (0, _extends2.default)({}, bothProps, {
        hideIcon: true,
        onChange: this.onTimeChange,
        selectProps: mergedTimePickerSelectProps,
        value: timeValue,
        timeIsEditable: timeIsEditable,
        times: times,
        timeFormat: timeFormat,
        locale: locale,
        testId: testId && "".concat(testId, "--timepicker")
      }, timePickerProps))), isClearable && !isDisabled ?
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
      (0, _react2.jsx)("button", {
        css: iconContainerStyles,
        onClick: this.onClear,
        "data-testid": testId && "".concat(testId, "--icon--container"),
        tabIndex: -1,
        type: "button"
      }, (0, _react2.jsx)(_selectClear.default, {
        size: "small",
        primaryColor: "inherit",
        label: "clear"
      })) : null);
    }
  }]);
  return DateTimePicker;
}(_react.default.Component);
exports.DateTimePickerWithoutAnalytics = DateTimePicker;
(0, _defineProperty2.default)(DateTimePicker, "defaultProps", dateTimePickerDefaultProps);
var _default = (0, _analyticsNext.withAnalyticsContext)({
  componentName: 'dateTimePicker',
  packageName: packageName,
  packageVersion: packageVersion
})((0, _analyticsNext.withAnalyticsEvents)({
  onChange: (0, _analyticsNext.createAndFireEvent)('atlaskit')({
    action: 'changed',
    actionSubject: 'dateTimePicker',
    attributes: {
      componentName: 'dateTimePicker',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(DateTimePicker));
exports.default = _default;