"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.TimePickerWithoutAnalytics = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _dateFns = require("date-fns");
var _pick = _interopRequireDefault(require("lodash/pick"));
var _analyticsNext = require("@atlaskit/analytics-next");
var _locale = require("@atlaskit/locale");
var _select = _interopRequireWildcard(require("@atlaskit/select"));
var _constants = require("@atlaskit/theme/constants");
var _internal = require("../internal");
var _fixedLayer = _interopRequireDefault(require("../internal/fixed-layer"));
var _parseTime = _interopRequireDefault(require("../internal/parse-time"));
var _utils = require("./utils");
var _excluded = ["selectProps"],
  _excluded2 = ["styles"];
/* eslint-disable @repo/internal/react/use-noop */
// eslint-disable-next-line no-restricted-imports
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
var packageName = "@atlaskit/datetime-picker";
var packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

var menuStyles = {
  /* Need to remove default absolute positioning as that causes issues with position fixed */
  position: 'static',
  /* Need to add overflow to the element with max-height, otherwise causes overflow issues in IE11 */
  overflowY: 'auto',
  /* React-Popper has already offset the menu so we need to reset the margin, otherwise the offset value is doubled */
  margin: 0
};
var FixedLayerMenu = function FixedLayerMenu(_ref) {
  var selectProps = _ref.selectProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return /*#__PURE__*/_react.default.createElement(_fixedLayer.default, {
    inputValue: selectProps.inputValue,
    containerRef: selectProps.fixedLayerRef,
    content: /*#__PURE__*/_react.default.createElement(_select.components.Menu, (0, _extends2.default)({}, rest, {
      menuShouldScrollIntoView: false
    })),
    testId: selectProps.testId
  });
};
var timePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  defaultIsOpen: false,
  defaultValue: '',
  hideIcon: false,
  id: '',
  innerProps: {},
  isDisabled: false,
  isInvalid: false,
  name: '',
  onBlur: function onBlur(event) {},
  onChange: function onChange(value) {},
  onFocus: function onFocus(event) {},
  parseInputValue: function parseInputValue(time, timeFormat) {
    return (0, _parseTime.default)(time);
  },
  selectProps: {},
  spacing: 'default',
  times: _internal.defaultTimes,
  timeIsEditable: false,
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};
var TimePicker = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(TimePicker, _React$Component);
  var _super = _createSuper(TimePicker);
  function TimePicker() {
    var _this;
    (0, _classCallCheck2.default)(this, TimePicker);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "containerRef", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isOpen: _this.props.defaultIsOpen,
      clearingFromIcon: false,
      value: _this.props.defaultValue,
      isFocused: false,
      l10n: (0, _locale.createLocalizationProvider)(_this.props.locale)
    });
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getSafeState", function () {
      return _objectSpread(_objectSpread({}, _this.state), (0, _pick.default)(_this.props, ['value', 'isOpen']));
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onChange", function (newValue, action) {
      var rawValue = newValue ? newValue.value || newValue : '';
      var value = rawValue.toString();
      var changedState = {
        value: value
      };
      if (action && action.action === 'clear') {
        changedState = _objectSpread(_objectSpread({}, changedState), {}, {
          clearingFromIcon: true
        });
      }
      _this.setState(changedState);
      _this.props.onChange(value);
    });
    /**
     * Only allow custom times if timeIsEditable prop is true
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onCreateOption", function (inputValue) {
      if (_this.props.timeIsEditable) {
        var _this$props = _this.props,
          parseInputValue = _this$props.parseInputValue,
          _timeFormat = _this$props.timeFormat;
        var sanitizedInput;
        try {
          sanitizedInput = parseInputValue(inputValue, _timeFormat || _internal.defaultTimeFormat);
        } catch (e) {
          return; // do nothing, the main validation should happen in the form
        }

        var formattedValue = (0, _dateFns.format)(sanitizedInput, 'HH:mm') || '';
        _this.setState({
          value: formattedValue
        });
        _this.props.onChange(formattedValue);
      } else {
        _this.onChange(inputValue);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMenuOpen", function () {
      // Don't open menu after the user has clicked clear
      if (_this.getSafeState().clearingFromIcon) {
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: true
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMenuClose", function () {
      // Don't close menu after the user has clicked clear
      if (_this.getSafeState().clearingFromIcon) {
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: false
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "setContainerRef", function (ref) {
      var oldRef = _this.containerRef;
      _this.containerRef = ref;
      // Cause a re-render if we're getting the container ref for the first time
      // as the layered menu requires it for dimension calculation
      if (oldRef == null && ref != null) {
        _this.forceUpdate();
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onBlur", function (event) {
      _this.setState({
        isFocused: false
      });
      _this.props.onBlur(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onFocus", function (event) {
      _this.setState({
        isFocused: true
      });
      _this.props.onFocus(event);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onSelectKeyDown", function (event) {
      var key = event.key;
      var keyPressed = key.toLowerCase();
      if (_this.getSafeState().clearingFromIcon && (keyPressed === 'backspace' || keyPressed === 'delete')) {
        // If being cleared from keyboard, don't change behaviour
        _this.setState({
          clearingFromIcon: false
        });
      }
    });
    /**
     * There are multiple props that can change how the time is formatted.
     * The priority of props used is:
     *   1. formatDisplayLabel
     *   2. timeFormat
     *   3. locale
     */
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "formatTime", function (time) {
      var _this$props2 = _this.props,
        formatDisplayLabel = _this$props2.formatDisplayLabel,
        timeFormat = _this$props2.timeFormat;
      var _this$getSafeState = _this.getSafeState(),
        l10n = _this$getSafeState.l10n;
      if (formatDisplayLabel) {
        return formatDisplayLabel(time, timeFormat || _internal.defaultTimeFormat);
      }
      var date = (0, _parseTime.default)(time);
      if (!(date instanceof Date)) {
        return '';
      }
      if (!(0, _dateFns.isValid)(date)) {
        return time;
      }
      if (timeFormat) {
        return (0, _dateFns.format)(date, (0, _utils.convertTokens)(timeFormat));
      }
      return l10n.formatTime(date);
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getPlaceholder", function () {
      var placeholder = _this.props.placeholder;
      if (placeholder) {
        return placeholder;
      }
      var _this$getSafeState2 = _this.getSafeState(),
        l10n = _this$getSafeState2.l10n;
      return l10n.formatTime(_internal.placeholderDatetime);
    });
    return _this;
  }
  (0, _createClass2.default)(TimePicker, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      if (this.props.locale !== nextProps.locale) {
        this.setState({
          l10n: (0, _locale.createLocalizationProvider)(nextProps.locale)
        });
      }
    }
  }, {
    key: "getOptions",
    value: function getOptions() {
      var _this2 = this;
      return this.props.times.map(function (time) {
        return {
          label: _this2.formatTime(time),
          value: time
        };
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$props3 = this.props,
        autoFocus = _this$props3.autoFocus,
        hideIcon = _this$props3.hideIcon,
        id = _this$props3.id,
        innerProps = _this$props3.innerProps,
        isDisabled = _this$props3.isDisabled,
        name = _this$props3.name,
        selectProps = _this$props3.selectProps,
        spacing = _this$props3.spacing,
        testId = _this$props3.testId,
        isInvalid = _this$props3.isInvalid,
        timeIsEditable = _this$props3.timeIsEditable;
      var ICON_PADDING = 2;
      var _this$getSafeState3 = this.getSafeState(),
        _this$getSafeState3$v = _this$getSafeState3.value,
        value = _this$getSafeState3$v === void 0 ? '' : _this$getSafeState3$v,
        isOpen = _this$getSafeState3.isOpen;
      var _selectProps$styles = selectProps.styles,
        selectStyles = _selectProps$styles === void 0 ? {} : _selectProps$styles,
        otherSelectProps = (0, _objectWithoutProperties2.default)(selectProps, _excluded2);
      var SelectComponent = timeIsEditable ? _select.CreatableSelect : _select.default;
      var labelAndValue = value && {
        label: this.formatTime(value),
        value: value
      };
      var selectComponents = _objectSpread({
        DropdownIndicator: _internal.EmptyComponent,
        Menu: FixedLayerMenu
      }, hideIcon && {
        ClearIndicator: _internal.EmptyComponent
      });
      var renderIconContainer = Boolean(!hideIcon && value);
      var mergedStyles = (0, _select.mergeStyles)(selectStyles, {
        control: function control(base) {
          return _objectSpread({}, base);
        },
        menu: function menu(base) {
          return _objectSpread(_objectSpread(_objectSpread({}, base), menuStyles), {}, {
            // Fixed positioned elements no longer inherit width from their parent, so we must explicitly set the
            // menu width to the width of our container
            width: _this3.containerRef ? _this3.containerRef.getBoundingClientRect().width : 'auto'
          });
        },
        indicatorsContainer: function indicatorsContainer(base) {
          return _objectSpread(_objectSpread({}, base), {}, {
            paddingLeft: renderIconContainer ? ICON_PADDING : 0,
            paddingRight: renderIconContainer ? (0, _constants.gridSize)() - ICON_PADDING : 0
          });
        }
      });
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/no-static-element-interactions
        _react.default.createElement("div", (0, _extends2.default)({}, innerProps, {
          ref: this.setContainerRef,
          "data-testid": testId && "".concat(testId, "--container"),
          onKeyDown: this.onSelectKeyDown
        }), /*#__PURE__*/_react.default.createElement("input", {
          name: name,
          type: "hidden",
          value: value,
          "data-testid": testId && "".concat(testId, "--input")
        }), /*#__PURE__*/_react.default.createElement(SelectComponent, (0, _extends2.default)({
          appearance: this.props.appearance,
          autoFocus: autoFocus,
          components: selectComponents,
          instanceId: id,
          isClearable: true,
          isDisabled: isDisabled,
          menuIsOpen: isOpen && !isDisabled,
          menuPlacement: "auto",
          openMenuOnFocus: true,
          onBlur: this.onBlur,
          onCreateOption: this.onCreateOption,
          onChange: this.onChange,
          options: this.getOptions(),
          onFocus: this.onFocus,
          onMenuOpen: this.onMenuOpen,
          onMenuClose: this.onMenuClose,
          placeholder: this.getPlaceholder(),
          styles: mergedStyles,
          value: labelAndValue,
          spacing: spacing
          // @ts-ignore caused by prop not part of @atlaskit/select
          ,
          fixedLayerRef: this.containerRef,
          isInvalid: isInvalid,
          testId: testId
        }, otherSelectProps)))
      );
    }
  }]);
  return TimePicker;
}(_react.default.Component);
exports.TimePickerWithoutAnalytics = TimePicker;
(0, _defineProperty2.default)(TimePicker, "defaultProps", timePickerDefaultProps);
var _default = (0, _analyticsNext.withAnalyticsContext)({
  componentName: 'timePicker',
  packageName: packageName,
  packageVersion: packageVersion
})((0, _analyticsNext.withAnalyticsEvents)({
  onChange: (0, _analyticsNext.createAndFireEvent)('atlaskit')({
    action: 'selectedTime',
    actionSubject: 'timePicker',
    attributes: {
      componentName: 'timePicker',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(TimePicker));
exports.default = _default;