"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactScrolllock = _interopRequireDefault(require("react-scrolllock"));
var _noop = _interopRequireDefault(require("@atlaskit/ds-lib/noop"));
var _icon = require("@atlaskit/icon");
var _platformFeatureFlags = require("@atlaskit/platform-feature-flags");
var _popper = require("@atlaskit/popper");
var _constants = require("@atlaskit/theme/constants");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } } // eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
/**
 * This component renders layered content with fixed positioning.
 * Scroll is locked outside the layer to prevent the layered content from detaching from the
 * container ref.
 */
var FixedLayer = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(FixedLayer, _React$Component);
  var _super = _createSuper(FixedLayer);
  function FixedLayer() {
    var _this;
    (0, _classCallCheck2.default)(this, FixedLayer);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "update", _noop.default);
    return _this;
  }
  (0, _createClass2.default)(FixedLayer, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.inputValue !== this.props.inputValue) {
        this.update();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        containerRef = _this$props.containerRef,
        content = _this$props.content,
        testId = _this$props.testId;

      // Wait for containerRef callback to cause a re-render
      if (!containerRef) {
        return /*#__PURE__*/_react.default.createElement("div", null);
      }
      return (
        /*#__PURE__*/
        /* Need to wrap layer in a fixed position div so that it will render its content as fixed
         * We need to set the intial top value to where the container is and zIndex so that it still
         * applies since we're creating a new stacking context. */
        _react.default.createElement(_popper.Manager, null, /*#__PURE__*/_react.default.createElement(_reactScrolllock.default, null), /*#__PURE__*/_react.default.createElement(_popper.Reference, null, function (_ref) {
          var ref = _ref.ref;
          return /*#__PURE__*/_react.default.createElement("div", {
            ref: ref,
            "data-layer-child": true,
            style: (0, _platformFeatureFlags.getBooleanFF)('platform.design-system-team.date-picker-input-a11y-fix_cbbxs') ? {
              inset: 0,
              pointerEvents: 'none',
              background: 'transparent'
            } : {
              position: 'absolute',
              top: 0,
              height: containerRef.getBoundingClientRect().height,
              // Don't block the clear button
              width: containerRef.getBoundingClientRect().width - parseInt(_icon.sizes.small.slice(0, -2)) - (0, _constants.gridSize)(),
              background: 'transparent'
            }
          });
        }), /*#__PURE__*/_react.default.createElement(_popper.Popper, null, function (_ref2) {
          var ref = _ref2.ref,
            style = _ref2.style,
            update = _ref2.update;
          _this2.update = update;
          return /*#__PURE__*/_react.default.createElement("div", {
            ref: ref,
            style: _objectSpread(_objectSpread({}, style), {}, {
              zIndex: _constants.layers.dialog()
            }),
            "data-testid": testId && "".concat(testId, "--popper--container")
          }, content);
        }))
      );
    }
  }]);
  return FixedLayer;
}(_react.default.Component);
exports.default = FixedLayer;