import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
/* eslint-disable @repo/internal/react/use-noop */
/** @jsx jsx */
import React from 'react';
import { css, jsx } from '@emotion/react';
// eslint-disable-next-line no-restricted-imports
import { format, isValid, parseISO } from 'date-fns';
import pick from 'lodash/pick';
import { createAndFireEvent, withAnalyticsContext, withAnalyticsEvents } from '@atlaskit/analytics-next';
import SelectClearIcon from '@atlaskit/icon/glyph/select-clear';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { mergeStyles } from '@atlaskit/select';
import { B100, N0, N100, N20, N30, N500, N70, R400 } from '@atlaskit/theme/colors';
import { defaultTimes, formatDateTimeZoneIntoIso } from '../internal';
import DatePicker from './date-picker';
import TimePicker from './time-picker';
import { convertTokens } from './utils';
const packageName = "@atlaskit/datetime-picker";
const packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

const isInvalidBorderStyles = css({
  borderColor: `var(--ds-border-danger, ${R400})`
});
const isFocusedBorderStyles = css({
  borderColor: `var(--ds-border-focused, ${B100})`
});
const isFocusedStyles = css({
  backgroundColor: `var(--ds-background-input-pressed, ${N0})`
});
const subtleBgStyles = css({
  backgroundColor: 'transparent',
  borderColor: 'transparent'
});
const subtleFocusedBgStyles = css({
  backgroundColor: "var(--ds-background-input-pressed, transparent)",
  borderColor: 'transparent'
});
const noBgStyles = css({
  backgroundColor: 'transparent',
  borderColor: 'transparent',
  '&:hover': {
    backgroundColor: 'transparent',
    borderColor: 'transparent'
  }
});
const hoverStyles = css({
  '&:hover': {
    backgroundColor: `var(--ds-background-input-hovered, ${N30})`,
    borderColor: `var(--ds-border-input, ${getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? N100 : N30})`
  }
});
const isInvalidHoverStyles = css({
  '&:hover': {
    backgroundColor: `var(--ds-background-input-hovered, ${N0})`,
    borderColor: `var(--ds-border-danger, ${R400})`
  }
});
const isDisabledStyles = css({
  '&:hover': {
    cursor: 'default'
  }
});
const baseContainerStyles = css({
  display: 'flex',
  backgroundColor: `var(--ds-background-input, ${N20})`,
  border: getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? `${"var(--ds-border-width, 1px)"} solid ${`var(--ds-border-input, ${N100})`}` : `2px solid ${`var(--ds-border-input, ${N20})`}`,
  borderRadius: "var(--ds-border-radius, 3px)",
  transition: 'background-color 200ms ease-in-out, border-color 200ms ease-in-out',
  '&:hover': {
    cursor: 'pointer'
  }
});

// Make DatePicker 50% the width of DateTimePicker
// If rendering an icon container, shrink the TimePicker
const datePickerContainerStyles = css({
  flexBasis: '50%',
  flexGrow: 1,
  flexShrink: 0
});
const timePickerContainerStyles = css({
  flexBasis: '50%',
  flexGrow: 1
});
const iconContainerStyles = css({
  display: 'flex',
  paddingTop: "var(--ds-space-075, 6px)",
  paddingRight: "var(--ds-space-100, 8px)",
  paddingBottom: "var(--ds-space-075, 6px)",
  paddingLeft: "var(--ds-space-050, 4px)",
  // ICON_PADDING (2) * 2
  alignItems: 'center',
  flexBasis: 'inherit',
  backgroundColor: 'inherit',
  border: 'none',
  color: `var(--ds-text-subtlest, ${N70})`,
  transition: `color 150ms`,
  '&:hover': {
    color: `var(--ds-text-subtle, ${N500})`
  }
});

// react-select overrides (via @atlaskit/select).
const styles = {
  control: style => ({
    ...style,
    backgroundColor: 'transparent',
    border: 2,
    borderRadius: 0,
    paddingLeft: 0,
    ':hover': {
      backgroundColor: 'transparent',
      cursor: 'inherit'
    }
  })
};
const dateTimePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  isDisabled: false,
  name: '',
  onBlur: event => {},
  onChange: value => {},
  onFocus: event => {},
  innerProps: {},
  id: '',
  defaultValue: '',
  timeIsEditable: false,
  isInvalid: false,
  datePickerProps: {},
  timePickerProps: {},
  datePickerSelectProps: {},
  timePickerSelectProps: {},
  times: defaultTimes,
  spacing: 'default',
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};

export const datePickerDefaultAriaLabel = 'Date';
export const timePickerDefaultAriaLabel = 'Time';
class DateTimePicker extends React.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      active: 0,
      dateValue: '',
      isFocused: false,
      timeValue: '',
      value: this.props.defaultValue,
      zoneValue: ''
    });
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    _defineProperty(this, "getSafeState", () => {
      const mappedState = {
        ...this.state,
        ...pick(this.props, ['value'])
      };
      return {
        ...mappedState,
        ...this.parseValue(mappedState.value, mappedState.dateValue, mappedState.timeValue, mappedState.zoneValue)
      };
    });
    _defineProperty(this, "onBlur", event => {
      this.setState({
        isFocused: false
      });
      this.props.onBlur(event);
    });
    _defineProperty(this, "onFocus", event => {
      this.setState({
        isFocused: true
      });
      this.props.onFocus(event);
    });
    _defineProperty(this, "onDateChange", dateValue => {
      this.onValueChange({
        ...this.getSafeState(),
        dateValue
      });
    });
    _defineProperty(this, "onTimeChange", timeValue => {
      this.onValueChange({
        ...this.getSafeState(),
        timeValue
      });
    });
    _defineProperty(this, "onClear", () => {
      this.onValueChange({
        ...this.getSafeState(),
        timeValue: '',
        dateValue: ''
      });
    });
  }
  parseValue(value, dateValue, timeValue, zoneValue) {
    if (this.props.parseValue) {
      return this.props.parseValue(value, dateValue, timeValue, zoneValue);
    }
    const parsed = parseISO(value);
    return isValid(parsed) ? {
      dateValue: format(parsed, convertTokens('YYYY-MM-DD')),
      timeValue: format(parsed, convertTokens('HH:mm')),
      zoneValue: format(parsed, convertTokens('ZZ'))
    } : {
      dateValue,
      timeValue,
      zoneValue
    };
  }
  onValueChange({
    dateValue,
    timeValue,
    zoneValue
  }) {
    this.setState({
      dateValue,
      timeValue,
      zoneValue
    });
    if (dateValue && timeValue) {
      const value = formatDateTimeZoneIntoIso(dateValue, timeValue, zoneValue);
      const {
        zoneValue: parsedZone
      } = this.parseValue(value, dateValue, timeValue, zoneValue);
      const valueWithValidZone = formatDateTimeZoneIntoIso(dateValue, timeValue, parsedZone);
      this.setState({
        value: valueWithValidZone
      });
      this.props.onChange(valueWithValidZone);
      // If the date or time value was cleared when there is an existing datetime value, then clear the value.
    } else if (this.getSafeState().value) {
      this.setState({
        value: ''
      });
      this.props.onChange('');
    }
  }
  render() {
    const {
      autoFocus,
      id,
      innerProps,
      isDisabled,
      name,
      timeIsEditable,
      dateFormat,
      datePickerProps,
      datePickerSelectProps,
      timePickerProps,
      timePickerSelectProps,
      times,
      timeFormat,
      locale,
      testId
    } = this.props;
    const {
      isFocused,
      value,
      dateValue,
      timeValue
    } = this.getSafeState();
    const bothProps = {
      isDisabled,
      onBlur: this.onBlur,
      onFocus: this.onFocus,
      isInvalid: this.props.isInvalid,
      appearance: this.props.appearance,
      spacing: this.props.spacing
    };
    const {
      styles: datePickerStyles = {}
    } = datePickerSelectProps;
    const {
      styles: timePickerStyles = {}
    } = timePickerSelectProps;
    const mergedDatePickerSelectProps = {
      ...datePickerSelectProps,
      'aria-label': datePickerSelectProps['aria-label'] || datePickerDefaultAriaLabel,
      styles: mergeStyles(styles, datePickerStyles)
    };
    const mergedTimePickerSelectProps = {
      ...timePickerSelectProps,
      'aria-label': timePickerSelectProps['aria-label'] || timePickerDefaultAriaLabel,
      styles: mergeStyles(styles, timePickerStyles)
    };

    // Render DateTimePicker's IconContainer when a value has been filled
    // Don't use Date or TimePicker's because they can't be customised
    const isClearable = Boolean(dateValue || timeValue);
    const notFocusedOrIsDisabled = !(isFocused || isDisabled);
    return jsx("div", _extends({
      css: [baseContainerStyles, isDisabled && isDisabledStyles, isFocused && isFocusedStyles, bothProps.appearance === 'subtle' && (isFocused ? subtleFocusedBgStyles : subtleBgStyles), isFocused && isFocusedBorderStyles, bothProps.isInvalid && isInvalidBorderStyles, notFocusedOrIsDisabled && (bothProps.isInvalid ? isInvalidHoverStyles : hoverStyles), bothProps.appearance === 'none' && noBgStyles]
    }, innerProps, {
      "data-testid": testId
    }), jsx("input", {
      name: name,
      type: "hidden",
      value: value,
      "data-testid": testId && `${testId}--input`
    }), jsx("div", {
      css: datePickerContainerStyles
    }, jsx(DatePicker, _extends({}, bothProps, {
      autoFocus: autoFocus,
      dateFormat: dateFormat,
      hideIcon: true,
      id: id,
      onChange: this.onDateChange,
      selectProps: mergedDatePickerSelectProps,
      value: dateValue,
      locale: locale,
      testId: testId && `${testId}--datepicker`
    }, datePickerProps))), jsx("div", {
      css: timePickerContainerStyles
    }, jsx(TimePicker, _extends({}, bothProps, {
      hideIcon: true,
      onChange: this.onTimeChange,
      selectProps: mergedTimePickerSelectProps,
      value: timeValue,
      timeIsEditable: timeIsEditable,
      times: times,
      timeFormat: timeFormat,
      locale: locale,
      testId: testId && `${testId}--timepicker`
    }, timePickerProps))), isClearable && !isDisabled ?
    // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
    jsx("button", {
      css: iconContainerStyles,
      onClick: this.onClear,
      "data-testid": testId && `${testId}--icon--container`,
      tabIndex: -1,
      type: "button"
    }, jsx(SelectClearIcon, {
      size: "small",
      primaryColor: "inherit",
      label: "clear"
    })) : null);
  }
}
_defineProperty(DateTimePicker, "defaultProps", dateTimePickerDefaultProps);
export { DateTimePicker as DateTimePickerWithoutAnalytics };
export default withAnalyticsContext({
  componentName: 'dateTimePicker',
  packageName,
  packageVersion
})(withAnalyticsEvents({
  onChange: createAndFireEvent('atlaskit')({
    action: 'changed',
    actionSubject: 'dateTimePicker',
    attributes: {
      componentName: 'dateTimePicker',
      packageName,
      packageVersion
    }
  })
})(DateTimePicker));