import _defineProperty from "@babel/runtime/helpers/defineProperty";
import React from 'react';
import ScrollLock from 'react-scrolllock';
import noop from '@atlaskit/ds-lib/noop';
import { sizes } from '@atlaskit/icon';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { Manager, Popper, Reference } from '@atlaskit/popper';
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize, layers } from '@atlaskit/theme/constants';
/**
 * This component renders layered content with fixed positioning.
 * Scroll is locked outside the layer to prevent the layered content from detaching from the
 * container ref.
 */
export default class FixedLayer extends React.Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "update", noop);
  }
  componentDidUpdate(prevProps) {
    if (prevProps.inputValue !== this.props.inputValue) {
      this.update();
    }
  }
  render() {
    const {
      containerRef,
      content,
      testId
    } = this.props;

    // Wait for containerRef callback to cause a re-render
    if (!containerRef) {
      return /*#__PURE__*/React.createElement("div", null);
    }
    return (
      /*#__PURE__*/
      /* Need to wrap layer in a fixed position div so that it will render its content as fixed
       * We need to set the intial top value to where the container is and zIndex so that it still
       * applies since we're creating a new stacking context. */
      React.createElement(Manager, null, /*#__PURE__*/React.createElement(ScrollLock, null), /*#__PURE__*/React.createElement(Reference, null, ({
        ref
      }) => /*#__PURE__*/React.createElement("div", {
        ref: ref,
        "data-layer-child": true,
        style: getBooleanFF('platform.design-system-team.date-picker-input-a11y-fix_cbbxs') ? {
          inset: 0,
          pointerEvents: 'none',
          background: 'transparent'
        } : {
          position: 'absolute',
          top: 0,
          height: containerRef.getBoundingClientRect().height,
          // Don't block the clear button
          width: containerRef.getBoundingClientRect().width - parseInt(sizes.small.slice(0, -2)) - gridSize(),
          background: 'transparent'
        }
      })), /*#__PURE__*/React.createElement(Popper, null, ({
        ref,
        style,
        update
      }) => {
        this.update = update;
        return /*#__PURE__*/React.createElement("div", {
          ref: ref,
          style: {
            ...style,
            zIndex: layers.dialog()
          },
          "data-testid": testId && `${testId}--popper--container`
        }, content);
      }))
    );
  }
}