import _extends from "@babel/runtime/helpers/extends";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/* eslint-disable @repo/internal/react/use-noop */
/** @jsx jsx */
import React from 'react';
import { css, jsx } from '@emotion/react';
// eslint-disable-next-line no-restricted-imports
import { format, isValid, parseISO } from 'date-fns';
import pick from 'lodash/pick';
import { createAndFireEvent, withAnalyticsContext, withAnalyticsEvents } from '@atlaskit/analytics-next';
import SelectClearIcon from '@atlaskit/icon/glyph/select-clear';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { mergeStyles } from '@atlaskit/select';
import { B100, N0, N100, N20, N30, N500, N70, R400 } from '@atlaskit/theme/colors';
import { defaultTimes, formatDateTimeZoneIntoIso } from '../internal';
import DatePicker from './date-picker';
import TimePicker from './time-picker';
import { convertTokens } from './utils';
var packageName = "@atlaskit/datetime-picker";
var packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

var isInvalidBorderStyles = css({
  borderColor: "var(--ds-border-danger, ".concat(R400, ")")
});
var isFocusedBorderStyles = css({
  borderColor: "var(--ds-border-focused, ".concat(B100, ")")
});
var isFocusedStyles = css({
  backgroundColor: "var(--ds-background-input-pressed, ".concat(N0, ")")
});
var subtleBgStyles = css({
  backgroundColor: 'transparent',
  borderColor: 'transparent'
});
var subtleFocusedBgStyles = css({
  backgroundColor: "var(--ds-background-input-pressed, transparent)",
  borderColor: 'transparent'
});
var noBgStyles = css({
  backgroundColor: 'transparent',
  borderColor: 'transparent',
  '&:hover': {
    backgroundColor: 'transparent',
    borderColor: 'transparent'
  }
});
var hoverStyles = css({
  '&:hover': {
    backgroundColor: "var(--ds-background-input-hovered, ".concat(N30, ")"),
    borderColor: "var(--ds-border-input, ".concat(getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? N100 : N30, ")")
  }
});
var isInvalidHoverStyles = css({
  '&:hover': {
    backgroundColor: "var(--ds-background-input-hovered, ".concat(N0, ")"),
    borderColor: "var(--ds-border-danger, ".concat(R400, ")")
  }
});
var isDisabledStyles = css({
  '&:hover': {
    cursor: 'default'
  }
});
var baseContainerStyles = css({
  display: 'flex',
  backgroundColor: "var(--ds-background-input, ".concat(N20, ")"),
  border: getBooleanFF('platform.design-system-team.border-checkbox_nyoiu') ? "var(--ds-border-width, 1px)".concat(" solid ", "var(--ds-border-input, ".concat(N100, ")")) : "2px solid ".concat("var(--ds-border-input, ".concat(N20, ")")),
  borderRadius: "var(--ds-border-radius, 3px)",
  transition: 'background-color 200ms ease-in-out, border-color 200ms ease-in-out',
  '&:hover': {
    cursor: 'pointer'
  }
});

// Make DatePicker 50% the width of DateTimePicker
// If rendering an icon container, shrink the TimePicker
var datePickerContainerStyles = css({
  flexBasis: '50%',
  flexGrow: 1,
  flexShrink: 0
});
var timePickerContainerStyles = css({
  flexBasis: '50%',
  flexGrow: 1
});
var iconContainerStyles = css({
  display: 'flex',
  paddingTop: "var(--ds-space-075, 6px)",
  paddingRight: "var(--ds-space-100, 8px)",
  paddingBottom: "var(--ds-space-075, 6px)",
  paddingLeft: "var(--ds-space-050, 4px)",
  // ICON_PADDING (2) * 2
  alignItems: 'center',
  flexBasis: 'inherit',
  backgroundColor: 'inherit',
  border: 'none',
  color: "var(--ds-text-subtlest, ".concat(N70, ")"),
  transition: "color 150ms",
  '&:hover': {
    color: "var(--ds-text-subtle, ".concat(N500, ")")
  }
});

// react-select overrides (via @atlaskit/select).
var styles = {
  control: function control(style) {
    return _objectSpread(_objectSpread({}, style), {}, {
      backgroundColor: 'transparent',
      border: 2,
      borderRadius: 0,
      paddingLeft: 0,
      ':hover': {
        backgroundColor: 'transparent',
        cursor: 'inherit'
      }
    });
  }
};
var dateTimePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  isDisabled: false,
  name: '',
  onBlur: function onBlur(event) {},
  onChange: function onChange(value) {},
  onFocus: function onFocus(event) {},
  innerProps: {},
  id: '',
  defaultValue: '',
  timeIsEditable: false,
  isInvalid: false,
  datePickerProps: {},
  timePickerProps: {},
  datePickerSelectProps: {},
  timePickerSelectProps: {},
  times: defaultTimes,
  spacing: 'default',
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};

export var datePickerDefaultAriaLabel = 'Date';
export var timePickerDefaultAriaLabel = 'Time';
var DateTimePicker = /*#__PURE__*/function (_React$Component) {
  _inherits(DateTimePicker, _React$Component);
  var _super = _createSuper(DateTimePicker);
  function DateTimePicker() {
    var _this;
    _classCallCheck(this, DateTimePicker);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      active: 0,
      dateValue: '',
      isFocused: false,
      timeValue: '',
      value: _this.props.defaultValue,
      zoneValue: ''
    });
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    _defineProperty(_assertThisInitialized(_this), "getSafeState", function () {
      var mappedState = _objectSpread(_objectSpread({}, _this.state), pick(_this.props, ['value']));
      return _objectSpread(_objectSpread({}, mappedState), _this.parseValue(mappedState.value, mappedState.dateValue, mappedState.timeValue, mappedState.zoneValue));
    });
    _defineProperty(_assertThisInitialized(_this), "onBlur", function (event) {
      _this.setState({
        isFocused: false
      });
      _this.props.onBlur(event);
    });
    _defineProperty(_assertThisInitialized(_this), "onFocus", function (event) {
      _this.setState({
        isFocused: true
      });
      _this.props.onFocus(event);
    });
    _defineProperty(_assertThisInitialized(_this), "onDateChange", function (dateValue) {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        dateValue: dateValue
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "onTimeChange", function (timeValue) {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        timeValue: timeValue
      }));
    });
    _defineProperty(_assertThisInitialized(_this), "onClear", function () {
      _this.onValueChange(_objectSpread(_objectSpread({}, _this.getSafeState()), {}, {
        timeValue: '',
        dateValue: ''
      }));
    });
    return _this;
  }
  _createClass(DateTimePicker, [{
    key: "parseValue",
    value: function parseValue(value, dateValue, timeValue, zoneValue) {
      if (this.props.parseValue) {
        return this.props.parseValue(value, dateValue, timeValue, zoneValue);
      }
      var parsed = parseISO(value);
      return isValid(parsed) ? {
        dateValue: format(parsed, convertTokens('YYYY-MM-DD')),
        timeValue: format(parsed, convertTokens('HH:mm')),
        zoneValue: format(parsed, convertTokens('ZZ'))
      } : {
        dateValue: dateValue,
        timeValue: timeValue,
        zoneValue: zoneValue
      };
    }
  }, {
    key: "onValueChange",
    value: function onValueChange(_ref) {
      var dateValue = _ref.dateValue,
        timeValue = _ref.timeValue,
        zoneValue = _ref.zoneValue;
      this.setState({
        dateValue: dateValue,
        timeValue: timeValue,
        zoneValue: zoneValue
      });
      if (dateValue && timeValue) {
        var _value = formatDateTimeZoneIntoIso(dateValue, timeValue, zoneValue);
        var _this$parseValue = this.parseValue(_value, dateValue, timeValue, zoneValue),
          parsedZone = _this$parseValue.zoneValue;
        var valueWithValidZone = formatDateTimeZoneIntoIso(dateValue, timeValue, parsedZone);
        this.setState({
          value: valueWithValidZone
        });
        this.props.onChange(valueWithValidZone);
        // If the date or time value was cleared when there is an existing datetime value, then clear the value.
      } else if (this.getSafeState().value) {
        this.setState({
          value: ''
        });
        this.props.onChange('');
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        autoFocus = _this$props.autoFocus,
        id = _this$props.id,
        innerProps = _this$props.innerProps,
        isDisabled = _this$props.isDisabled,
        name = _this$props.name,
        timeIsEditable = _this$props.timeIsEditable,
        dateFormat = _this$props.dateFormat,
        datePickerProps = _this$props.datePickerProps,
        datePickerSelectProps = _this$props.datePickerSelectProps,
        timePickerProps = _this$props.timePickerProps,
        timePickerSelectProps = _this$props.timePickerSelectProps,
        times = _this$props.times,
        timeFormat = _this$props.timeFormat,
        locale = _this$props.locale,
        testId = _this$props.testId;
      var _this$getSafeState = this.getSafeState(),
        isFocused = _this$getSafeState.isFocused,
        value = _this$getSafeState.value,
        dateValue = _this$getSafeState.dateValue,
        timeValue = _this$getSafeState.timeValue;
      var bothProps = {
        isDisabled: isDisabled,
        onBlur: this.onBlur,
        onFocus: this.onFocus,
        isInvalid: this.props.isInvalid,
        appearance: this.props.appearance,
        spacing: this.props.spacing
      };
      var _datePickerSelectProp = datePickerSelectProps.styles,
        datePickerStyles = _datePickerSelectProp === void 0 ? {} : _datePickerSelectProp;
      var _timePickerSelectProp = timePickerSelectProps.styles,
        timePickerStyles = _timePickerSelectProp === void 0 ? {} : _timePickerSelectProp;
      var mergedDatePickerSelectProps = _objectSpread(_objectSpread({}, datePickerSelectProps), {}, {
        'aria-label': datePickerSelectProps['aria-label'] || datePickerDefaultAriaLabel,
        styles: mergeStyles(styles, datePickerStyles)
      });
      var mergedTimePickerSelectProps = _objectSpread(_objectSpread({}, timePickerSelectProps), {}, {
        'aria-label': timePickerSelectProps['aria-label'] || timePickerDefaultAriaLabel,
        styles: mergeStyles(styles, timePickerStyles)
      });

      // Render DateTimePicker's IconContainer when a value has been filled
      // Don't use Date or TimePicker's because they can't be customised
      var isClearable = Boolean(dateValue || timeValue);
      var notFocusedOrIsDisabled = !(isFocused || isDisabled);
      return jsx("div", _extends({
        css: [baseContainerStyles, isDisabled && isDisabledStyles, isFocused && isFocusedStyles, bothProps.appearance === 'subtle' && (isFocused ? subtleFocusedBgStyles : subtleBgStyles), isFocused && isFocusedBorderStyles, bothProps.isInvalid && isInvalidBorderStyles, notFocusedOrIsDisabled && (bothProps.isInvalid ? isInvalidHoverStyles : hoverStyles), bothProps.appearance === 'none' && noBgStyles]
      }, innerProps, {
        "data-testid": testId
      }), jsx("input", {
        name: name,
        type: "hidden",
        value: value,
        "data-testid": testId && "".concat(testId, "--input")
      }), jsx("div", {
        css: datePickerContainerStyles
      }, jsx(DatePicker, _extends({}, bothProps, {
        autoFocus: autoFocus,
        dateFormat: dateFormat,
        hideIcon: true,
        id: id,
        onChange: this.onDateChange,
        selectProps: mergedDatePickerSelectProps,
        value: dateValue,
        locale: locale,
        testId: testId && "".concat(testId, "--datepicker")
      }, datePickerProps))), jsx("div", {
        css: timePickerContainerStyles
      }, jsx(TimePicker, _extends({}, bothProps, {
        hideIcon: true,
        onChange: this.onTimeChange,
        selectProps: mergedTimePickerSelectProps,
        value: timeValue,
        timeIsEditable: timeIsEditable,
        times: times,
        timeFormat: timeFormat,
        locale: locale,
        testId: testId && "".concat(testId, "--timepicker")
      }, timePickerProps))), isClearable && !isDisabled ?
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events,jsx-a11y/no-static-element-interactions
      jsx("button", {
        css: iconContainerStyles,
        onClick: this.onClear,
        "data-testid": testId && "".concat(testId, "--icon--container"),
        tabIndex: -1,
        type: "button"
      }, jsx(SelectClearIcon, {
        size: "small",
        primaryColor: "inherit",
        label: "clear"
      })) : null);
    }
  }]);
  return DateTimePicker;
}(React.Component);
_defineProperty(DateTimePicker, "defaultProps", dateTimePickerDefaultProps);
export { DateTimePicker as DateTimePickerWithoutAnalytics };
export default withAnalyticsContext({
  componentName: 'dateTimePicker',
  packageName: packageName,
  packageVersion: packageVersion
})(withAnalyticsEvents({
  onChange: createAndFireEvent('atlaskit')({
    action: 'changed',
    actionSubject: 'dateTimePicker',
    attributes: {
      componentName: 'dateTimePicker',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(DateTimePicker));