import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["selectProps"],
  _excluded2 = ["styles"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/* eslint-disable @repo/internal/react/use-noop */
import React from 'react';

// eslint-disable-next-line no-restricted-imports
import { format, isValid } from 'date-fns';
import pick from 'lodash/pick';
import { createAndFireEvent, withAnalyticsContext, withAnalyticsEvents } from '@atlaskit/analytics-next';
import { createLocalizationProvider } from '@atlaskit/locale';
import Select, { components, CreatableSelect, mergeStyles } from '@atlaskit/select';
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize } from '@atlaskit/theme/constants';
import { defaultTimeFormat, defaultTimes, EmptyComponent, placeholderDatetime } from '../internal';
import FixedLayer from '../internal/fixed-layer';
import parseTime from '../internal/parse-time';
import { convertTokens } from './utils';
var packageName = "@atlaskit/datetime-picker";
var packageVersion = "12.7.7";

/* eslint-disable react/no-unused-prop-types */

var menuStyles = {
  /* Need to remove default absolute positioning as that causes issues with position fixed */
  position: 'static',
  /* Need to add overflow to the element with max-height, otherwise causes overflow issues in IE11 */
  overflowY: 'auto',
  /* React-Popper has already offset the menu so we need to reset the margin, otherwise the offset value is doubled */
  margin: 0
};
var FixedLayerMenu = function FixedLayerMenu(_ref) {
  var selectProps = _ref.selectProps,
    rest = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/React.createElement(FixedLayer, {
    inputValue: selectProps.inputValue,
    containerRef: selectProps.fixedLayerRef,
    content: /*#__PURE__*/React.createElement(components.Menu, _extends({}, rest, {
      menuShouldScrollIntoView: false
    })),
    testId: selectProps.testId
  });
};
var timePickerDefaultProps = {
  appearance: 'default',
  autoFocus: false,
  defaultIsOpen: false,
  defaultValue: '',
  hideIcon: false,
  id: '',
  innerProps: {},
  isDisabled: false,
  isInvalid: false,
  name: '',
  onBlur: function onBlur(event) {},
  onChange: function onChange(value) {},
  onFocus: function onFocus(event) {},
  parseInputValue: function parseInputValue(time, timeFormat) {
    return parseTime(time);
  },
  selectProps: {},
  spacing: 'default',
  times: defaultTimes,
  timeIsEditable: false,
  locale: 'en-US'
  // Not including a default prop for value as it will
  // Make the component a controlled component
};
var TimePicker = /*#__PURE__*/function (_React$Component) {
  _inherits(TimePicker, _React$Component);
  var _super = _createSuper(TimePicker);
  function TimePicker() {
    var _this;
    _classCallCheck(this, TimePicker);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "containerRef", null);
    _defineProperty(_assertThisInitialized(_this), "state", {
      isOpen: _this.props.defaultIsOpen,
      clearingFromIcon: false,
      value: _this.props.defaultValue,
      isFocused: false,
      l10n: createLocalizationProvider(_this.props.locale)
    });
    // All state needs to be accessed via this function so that the state is mapped from props
    // correctly to allow controlled/uncontrolled usage.
    _defineProperty(_assertThisInitialized(_this), "getSafeState", function () {
      return _objectSpread(_objectSpread({}, _this.state), pick(_this.props, ['value', 'isOpen']));
    });
    _defineProperty(_assertThisInitialized(_this), "onChange", function (newValue, action) {
      var rawValue = newValue ? newValue.value || newValue : '';
      var value = rawValue.toString();
      var changedState = {
        value: value
      };
      if (action && action.action === 'clear') {
        changedState = _objectSpread(_objectSpread({}, changedState), {}, {
          clearingFromIcon: true
        });
      }
      _this.setState(changedState);
      _this.props.onChange(value);
    });
    /**
     * Only allow custom times if timeIsEditable prop is true
     */
    _defineProperty(_assertThisInitialized(_this), "onCreateOption", function (inputValue) {
      if (_this.props.timeIsEditable) {
        var _this$props = _this.props,
          parseInputValue = _this$props.parseInputValue,
          _timeFormat = _this$props.timeFormat;
        var sanitizedInput;
        try {
          sanitizedInput = parseInputValue(inputValue, _timeFormat || defaultTimeFormat);
        } catch (e) {
          return; // do nothing, the main validation should happen in the form
        }

        var formattedValue = format(sanitizedInput, 'HH:mm') || '';
        _this.setState({
          value: formattedValue
        });
        _this.props.onChange(formattedValue);
      } else {
        _this.onChange(inputValue);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onMenuOpen", function () {
      // Don't open menu after the user has clicked clear
      if (_this.getSafeState().clearingFromIcon) {
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: true
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onMenuClose", function () {
      // Don't close menu after the user has clicked clear
      if (_this.getSafeState().clearingFromIcon) {
        _this.setState({
          clearingFromIcon: false
        });
      } else {
        _this.setState({
          isOpen: false
        });
      }
    });
    _defineProperty(_assertThisInitialized(_this), "setContainerRef", function (ref) {
      var oldRef = _this.containerRef;
      _this.containerRef = ref;
      // Cause a re-render if we're getting the container ref for the first time
      // as the layered menu requires it for dimension calculation
      if (oldRef == null && ref != null) {
        _this.forceUpdate();
      }
    });
    _defineProperty(_assertThisInitialized(_this), "onBlur", function (event) {
      _this.setState({
        isFocused: false
      });
      _this.props.onBlur(event);
    });
    _defineProperty(_assertThisInitialized(_this), "onFocus", function (event) {
      _this.setState({
        isFocused: true
      });
      _this.props.onFocus(event);
    });
    _defineProperty(_assertThisInitialized(_this), "onSelectKeyDown", function (event) {
      var key = event.key;
      var keyPressed = key.toLowerCase();
      if (_this.getSafeState().clearingFromIcon && (keyPressed === 'backspace' || keyPressed === 'delete')) {
        // If being cleared from keyboard, don't change behaviour
        _this.setState({
          clearingFromIcon: false
        });
      }
    });
    /**
     * There are multiple props that can change how the time is formatted.
     * The priority of props used is:
     *   1. formatDisplayLabel
     *   2. timeFormat
     *   3. locale
     */
    _defineProperty(_assertThisInitialized(_this), "formatTime", function (time) {
      var _this$props2 = _this.props,
        formatDisplayLabel = _this$props2.formatDisplayLabel,
        timeFormat = _this$props2.timeFormat;
      var _this$getSafeState = _this.getSafeState(),
        l10n = _this$getSafeState.l10n;
      if (formatDisplayLabel) {
        return formatDisplayLabel(time, timeFormat || defaultTimeFormat);
      }
      var date = parseTime(time);
      if (!(date instanceof Date)) {
        return '';
      }
      if (!isValid(date)) {
        return time;
      }
      if (timeFormat) {
        return format(date, convertTokens(timeFormat));
      }
      return l10n.formatTime(date);
    });
    _defineProperty(_assertThisInitialized(_this), "getPlaceholder", function () {
      var placeholder = _this.props.placeholder;
      if (placeholder) {
        return placeholder;
      }
      var _this$getSafeState2 = _this.getSafeState(),
        l10n = _this$getSafeState2.l10n;
      return l10n.formatTime(placeholderDatetime);
    });
    return _this;
  }
  _createClass(TimePicker, [{
    key: "UNSAFE_componentWillReceiveProps",
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      if (this.props.locale !== nextProps.locale) {
        this.setState({
          l10n: createLocalizationProvider(nextProps.locale)
        });
      }
    }
  }, {
    key: "getOptions",
    value: function getOptions() {
      var _this2 = this;
      return this.props.times.map(function (time) {
        return {
          label: _this2.formatTime(time),
          value: time
        };
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;
      var _this$props3 = this.props,
        autoFocus = _this$props3.autoFocus,
        hideIcon = _this$props3.hideIcon,
        id = _this$props3.id,
        innerProps = _this$props3.innerProps,
        isDisabled = _this$props3.isDisabled,
        name = _this$props3.name,
        selectProps = _this$props3.selectProps,
        spacing = _this$props3.spacing,
        testId = _this$props3.testId,
        isInvalid = _this$props3.isInvalid,
        timeIsEditable = _this$props3.timeIsEditable;
      var ICON_PADDING = 2;
      var _this$getSafeState3 = this.getSafeState(),
        _this$getSafeState3$v = _this$getSafeState3.value,
        value = _this$getSafeState3$v === void 0 ? '' : _this$getSafeState3$v,
        isOpen = _this$getSafeState3.isOpen;
      var _selectProps$styles = selectProps.styles,
        selectStyles = _selectProps$styles === void 0 ? {} : _selectProps$styles,
        otherSelectProps = _objectWithoutProperties(selectProps, _excluded2);
      var SelectComponent = timeIsEditable ? CreatableSelect : Select;
      var labelAndValue = value && {
        label: this.formatTime(value),
        value: value
      };
      var selectComponents = _objectSpread({
        DropdownIndicator: EmptyComponent,
        Menu: FixedLayerMenu
      }, hideIcon && {
        ClearIndicator: EmptyComponent
      });
      var renderIconContainer = Boolean(!hideIcon && value);
      var mergedStyles = mergeStyles(selectStyles, {
        control: function control(base) {
          return _objectSpread({}, base);
        },
        menu: function menu(base) {
          return _objectSpread(_objectSpread(_objectSpread({}, base), menuStyles), {}, {
            // Fixed positioned elements no longer inherit width from their parent, so we must explicitly set the
            // menu width to the width of our container
            width: _this3.containerRef ? _this3.containerRef.getBoundingClientRect().width : 'auto'
          });
        },
        indicatorsContainer: function indicatorsContainer(base) {
          return _objectSpread(_objectSpread({}, base), {}, {
            paddingLeft: renderIconContainer ? ICON_PADDING : 0,
            paddingRight: renderIconContainer ? gridSize() - ICON_PADDING : 0
          });
        }
      });
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/no-static-element-interactions
        React.createElement("div", _extends({}, innerProps, {
          ref: this.setContainerRef,
          "data-testid": testId && "".concat(testId, "--container"),
          onKeyDown: this.onSelectKeyDown
        }), /*#__PURE__*/React.createElement("input", {
          name: name,
          type: "hidden",
          value: value,
          "data-testid": testId && "".concat(testId, "--input")
        }), /*#__PURE__*/React.createElement(SelectComponent, _extends({
          appearance: this.props.appearance,
          autoFocus: autoFocus,
          components: selectComponents,
          instanceId: id,
          isClearable: true,
          isDisabled: isDisabled,
          menuIsOpen: isOpen && !isDisabled,
          menuPlacement: "auto",
          openMenuOnFocus: true,
          onBlur: this.onBlur,
          onCreateOption: this.onCreateOption,
          onChange: this.onChange,
          options: this.getOptions(),
          onFocus: this.onFocus,
          onMenuOpen: this.onMenuOpen,
          onMenuClose: this.onMenuClose,
          placeholder: this.getPlaceholder(),
          styles: mergedStyles,
          value: labelAndValue,
          spacing: spacing
          // @ts-ignore caused by prop not part of @atlaskit/select
          ,
          fixedLayerRef: this.containerRef,
          isInvalid: isInvalid,
          testId: testId
        }, otherSelectProps)))
      );
    }
  }]);
  return TimePicker;
}(React.Component);
_defineProperty(TimePicker, "defaultProps", timePickerDefaultProps);
export { TimePicker as TimePickerWithoutAnalytics };
export default withAnalyticsContext({
  componentName: 'timePicker',
  packageName: packageName,
  packageVersion: packageVersion
})(withAnalyticsEvents({
  onChange: createAndFireEvent('atlaskit')({
    action: 'selectedTime',
    actionSubject: 'timePicker',
    attributes: {
      componentName: 'timePicker',
      packageName: packageName,
      packageVersion: packageVersion
    }
  })
})(TimePicker));