import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
import React from 'react';
import ScrollLock from 'react-scrolllock';
import noop from '@atlaskit/ds-lib/noop';
import { sizes } from '@atlaskit/icon';
import { getBooleanFF } from '@atlaskit/platform-feature-flags';
import { Manager, Popper, Reference } from '@atlaskit/popper';
// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports
import { gridSize, layers } from '@atlaskit/theme/constants';
/**
 * This component renders layered content with fixed positioning.
 * Scroll is locked outside the layer to prevent the layered content from detaching from the
 * container ref.
 */
var FixedLayer = /*#__PURE__*/function (_React$Component) {
  _inherits(FixedLayer, _React$Component);
  var _super = _createSuper(FixedLayer);
  function FixedLayer() {
    var _this;
    _classCallCheck(this, FixedLayer);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "update", noop);
    return _this;
  }
  _createClass(FixedLayer, [{
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      if (prevProps.inputValue !== this.props.inputValue) {
        this.update();
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;
      var _this$props = this.props,
        containerRef = _this$props.containerRef,
        content = _this$props.content,
        testId = _this$props.testId;

      // Wait for containerRef callback to cause a re-render
      if (!containerRef) {
        return /*#__PURE__*/React.createElement("div", null);
      }
      return (
        /*#__PURE__*/
        /* Need to wrap layer in a fixed position div so that it will render its content as fixed
         * We need to set the intial top value to where the container is and zIndex so that it still
         * applies since we're creating a new stacking context. */
        React.createElement(Manager, null, /*#__PURE__*/React.createElement(ScrollLock, null), /*#__PURE__*/React.createElement(Reference, null, function (_ref) {
          var ref = _ref.ref;
          return /*#__PURE__*/React.createElement("div", {
            ref: ref,
            "data-layer-child": true,
            style: getBooleanFF('platform.design-system-team.date-picker-input-a11y-fix_cbbxs') ? {
              inset: 0,
              pointerEvents: 'none',
              background: 'transparent'
            } : {
              position: 'absolute',
              top: 0,
              height: containerRef.getBoundingClientRect().height,
              // Don't block the clear button
              width: containerRef.getBoundingClientRect().width - parseInt(sizes.small.slice(0, -2)) - gridSize(),
              background: 'transparent'
            }
          });
        }), /*#__PURE__*/React.createElement(Popper, null, function (_ref2) {
          var ref = _ref2.ref,
            style = _ref2.style,
            update = _ref2.update;
          _this2.update = update;
          return /*#__PURE__*/React.createElement("div", {
            ref: ref,
            style: _objectSpread(_objectSpread({}, style), {}, {
              zIndex: layers.dialog()
            }),
            "data-testid": testId && "".concat(testId, "--popper--container")
          }, content);
        }))
      );
    }
  }]);
  return FixedLayer;
}(React.Component);
export { FixedLayer as default };