/** @jsx jsx */
import { Component } from 'react';
import { jsx } from '@emotion/react';
import { WithAnalyticsEventsProps } from '@atlaskit/analytics-next';
import { CalendarRef } from '@atlaskit/calendar';
import { LocalizationProvider } from '@atlaskit/locale';
import { ActionMeta, DropdownIndicatorProps, OptionType, ValueType } from '@atlaskit/select';
import { Appearance, SelectProps, Spacing } from '../types';
export interface DatePickerBaseProps extends WithAnalyticsEventsProps {
    /**
     * Set the appearance of the picker.
     *
     * `subtle` will remove the borders, background, and icon.
     *
     *NOTE:** Appearance values will be ignored if styles are parsed through `selectProps`.
     */
    appearance?: Appearance;
    /**
     * Set the picker to autofocus on mount.
     */
    autoFocus?: boolean;
    /**
     * The default for `isOpen`. Will be `false` if not provided.
     */
    defaultIsOpen?: boolean;
    /**
     * The default for `value`.
     */
    defaultValue?: string;
    /**
     * An array of ISO dates that should be disabled on the calendar. This does not affect what users can type into the picker.
     */
    disabled?: string[];
    /**
     * A filter function for disabling dates on the calendar. This does not affect what users can type into the picker.
     *
     * The function is called with a date string in the format `YYYY-MM-DD` and should return `true` if the date should be disabled.
     */
    disabledDateFilter?: (date: string) => boolean;
    /**
     * The latest enabled date. Dates after this are disabled on the calendar. This does not affect what users can type into the picker.
     */
    maxDate?: string;
    /**
     * The earliest enabled date. Dates before this are disabled on the calendar. This does not affect what users can type into the picker.
     */
    minDate?: string;
    /**
     * The icon shown in the picker.
     */
    icon?: React.ComponentType<DropdownIndicatorProps<OptionType>>;
    /**
     * The id of the field. Currently, react-select transforms this to have a `react-select-` prefix, and an `--input` suffix when applied to the input. For example, the id `my-input` would be transformed to `react-select-my-input--input`.
     *
     * Keep this in mind when needing to refer to the ID. This will be fixed in an upcoming release.
     */
    id?: string;
    /**
     * Props to apply to the container.
     */
    innerProps?: React.AllHTMLAttributes<HTMLElement>;
    /**
     * Set if the picker is disabled.
     */
    isDisabled?: boolean;
    /**
     * Set if the picker is open.
     */
    isOpen?: boolean;
    /**
     * The name of the field.
     */
    name?: string;
    /**
     * The aria-label attribute associated with the next-month arrow.
     */
    nextMonthLabel?: string;
    /**
     * Called when the field is blurred.
     */
    onBlur?: React.FocusEventHandler<HTMLInputElement>;
    /**
     * Called when the value changes. The only argument is an ISO time or empty string.
     */
    onChange?: (value: string) => void;
    /**
     * Called when the field is focused.
     */
    onFocus?: React.FocusEventHandler<HTMLInputElement>;
    /**
     * A function for parsing input characters and transforming them into a Date object. By default parses the date string based off the locale.
     */
    parseInputValue?: (date: string, dateFormat: string) => Date;
    /**
     * A function for formatting the date displayed in the input. By default composes together [date-fn's parse method](https://date-fns.org/v1.29.0/docs/parse) and [date-fn's format method](https://date-fns.org/v1.29.0/docs/format) to return a correctly formatted date string.
     */
    formatDisplayLabel?: (value: string, dateFormat: string) => string;
    /**
     * The aria-label attribute associated with the previous-month arrow.
     */
    previousMonthLabel?: string;
    /**
     * Props to apply to the select. This can be used to set options such as placeholder text.
     *  See [the `Select` documentation for further information](/components/select).
     */
    selectProps?: SelectProps;
    /**
     * The spacing for the select control.
     *
     * Compact is `gridSize() * 4`, default is `gridSize * 5`.
     */
    spacing?: Spacing;
    /**
     * The ISO time used as the input value.
     */
    value?: string;
    /**
     * Set if the picker has an invalid value.
     */
    isInvalid?: boolean;
    /**
     * Hides icon for dropdown indicator.
     */
    hideIcon?: boolean;
    /**
     * Format the date with a string that is accepted by [date-fn's format function](https://date-fns.org/v1.29.0/docs/format).
     */
    dateFormat?: string;
    /**
     * Placeholder text displayed in input
     */
    placeholder?: string;
    /**
     * Locale used to format the date and calendar. See [DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat).
     */
    locale?: string;
    /**
     * A `testId` prop is provided for specified elements, which is a unique string that appears as a data attribute `data-testid` in the rendered code, serving as a hook for automated tests
     *  - `{testId}--container` wrapping element of date-picker
     *  - `{testId}--calendar--container` nested calendar component
     */
    testId?: string;
    /**
     * Start day of the week for the calendar.
     * - `0` sunday (default value)
     * - `1` monday
     * - `2` tuesday
     * - `3` wednesday
     * - `4` thursday
     * - `5` friday
     * - `6` saturday
     */
    weekStartDay?: 0 | 1 | 2 | 3 | 4 | 5 | 6;
}
type DatePickerProps = typeof datePickerDefaultProps & DatePickerBaseProps;
interface State {
    isOpen: boolean;
    /**
     * When being cleared from the icon the DatePicker is blurred.
     * This variable defines whether the default onSelectBlur or onSelectFocus
     * events should behave as normal
     */
    isFocused: boolean;
    clearingFromIcon: boolean;
    value: string;
    calendarValue: string;
    selectInputValue: string;
    l10n: LocalizationProvider;
}
declare const datePickerDefaultProps: {
    appearance: Appearance;
    autoFocus: boolean;
    defaultIsOpen: boolean;
    defaultValue: string;
    disabled: string[];
    disabledDateFilter: (_: string) => boolean;
    hideIcon: boolean;
    icon: import("react").ComponentType<DropdownIndicatorProps<OptionType, boolean, import("@atlaskit/select").GroupType<OptionType>>>;
    id: string;
    innerProps: {};
    isDisabled: boolean;
    isInvalid: boolean;
    name: string;
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    selectProps: {};
    spacing: Spacing;
    locale: string;
};
declare class DatePicker extends Component<DatePickerProps, State> {
    static defaultProps: {
        appearance: Appearance;
        autoFocus: boolean;
        defaultIsOpen: boolean;
        defaultValue: string;
        disabled: string[];
        disabledDateFilter: (_: string) => boolean;
        hideIcon: boolean;
        icon: import("react").ComponentType<DropdownIndicatorProps<OptionType, boolean, import("@atlaskit/select").GroupType<OptionType>>>;
        id: string;
        innerProps: {};
        isDisabled: boolean;
        isInvalid: boolean;
        name: string;
        onBlur: (event: import("react").FocusEvent<HTMLInputElement>) => void;
        onChange: (value: string) => void;
        onFocus: (event: import("react").FocusEvent<HTMLInputElement>) => void;
        selectProps: {};
        spacing: Spacing;
        locale: string;
    };
    calendarRef: CalendarRef | null;
    containerRef: HTMLElement | null;
    constructor(props: any);
    UNSAFE_componentWillReceiveProps(nextProps: Readonly<DatePickerProps>): void;
    getSafeState: () => {
        inputValue: any;
        isOpen: boolean;
        value: string;
        isFocused: boolean;
        clearingFromIcon: boolean;
        calendarValue: string;
        selectInputValue: string;
        l10n: LocalizationProvider;
    };
    isDateDisabled: (date: string) => boolean;
    onCalendarChange: ({ iso }: {
        iso: string;
    }) => void;
    onCalendarSelect: ({ iso }: {
        iso: string;
    }) => void;
    onInputClick: () => void;
    onSelectBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onSelectFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    onTextInput: (event: React.ChangeEvent<HTMLInputElement>) => void;
    getSafeCalendarValue: (calendarValue: string) => string;
    onInputKeyDown: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    onClear: () => void;
    onSelectChange: (value: ValueType<OptionType>, action: ActionMeta) => void;
    refCalendar: (ref: CalendarRef | null) => void;
    handleSelectInputChange: (selectInputValue: string, actionMeta: {}) => void;
    getContainerRef: (ref: HTMLElement | null) => void;
    /**
     * There are two props that can change how the date is parsed.
     * The priority of props used is:
     *   1. parseInputValue
     *   2. locale
     */
    parseDate: (date: string) => Date;
    /**
     * There are multiple props that can change how the date is formatted.
     * The priority of props used is:
     *   1. formatDisplayLabel
     *   2. dateFormat
     *   3. locale
     */
    formatDate: (value: string) => string;
    getPlaceholder: () => string;
    render(): jsx.JSX.Element;
}
export { DatePicker as DatePickerWithoutAnalytics };
declare const _default: import("react").ForwardRefExoticComponent<Pick<Pick<Omit<DatePickerProps, keyof WithAnalyticsEventsProps>, "testId" | "maxDate" | "minDate" | "isOpen" | "nextMonthLabel" | "parseInputValue" | "formatDisplayLabel" | "previousMonthLabel" | "value" | "dateFormat" | "placeholder" | "weekStartDay"> & Partial<Pick<Omit<DatePickerProps, keyof WithAnalyticsEventsProps>, "icon" | "disabled" | "appearance" | "autoFocus" | "defaultIsOpen" | "defaultValue" | "disabledDateFilter" | "id" | "innerProps" | "isDisabled" | "name" | "onBlur" | "onChange" | "onFocus" | "selectProps" | "spacing" | "isInvalid" | "hideIcon" | "locale">> & Partial<Pick<{
    appearance: Appearance;
    autoFocus: boolean;
    defaultIsOpen: boolean;
    defaultValue: string;
    disabled: string[];
    disabledDateFilter: (_: string) => boolean;
    hideIcon: boolean;
    icon: import("react").ComponentType<DropdownIndicatorProps<OptionType, boolean, import("@atlaskit/select").GroupType<OptionType>>>;
    id: string;
    innerProps: {};
    isDisabled: boolean;
    isInvalid: boolean;
    name: string;
    onBlur: (event: import("react").FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: import("react").FocusEvent<HTMLInputElement>) => void;
    selectProps: {};
    spacing: Spacing;
    locale: string;
}, never>> & import("react").RefAttributes<any> & import("@atlaskit/analytics-next").WithContextProps, "testId" | "icon" | "disabled" | "appearance" | "autoFocus" | "defaultIsOpen" | "defaultValue" | "disabledDateFilter" | "maxDate" | "minDate" | "id" | "innerProps" | "isDisabled" | "isOpen" | "name" | "nextMonthLabel" | "onBlur" | "onChange" | "onFocus" | "parseInputValue" | "formatDisplayLabel" | "previousMonthLabel" | "selectProps" | "spacing" | "value" | "isInvalid" | "hideIcon" | "dateFormat" | "placeholder" | "locale" | "weekStartDay" | "key" | "analyticsContext"> & import("react").RefAttributes<any>>;
export default _default;
