import React from 'react';
import { WithAnalyticsEventsProps } from '@atlaskit/analytics-next';
import { LocalizationProvider } from '@atlaskit/locale';
import { ActionMeta, OptionType, SelectProps, ValueType } from '@atlaskit/select';
import { Appearance, Spacing } from '../types';
interface Option {
    label: string;
    value: string;
}
export interface TimePickerBaseProps extends WithAnalyticsEventsProps {
    /**
     * Set the appearance of the picker.
     * `subtle` will remove the borders, background, and icon.
     *
     * __NOTE:__ Appearance values will be ignored if styles are parsed through `selectProps`.
     */
    appearance?: Appearance;
    /**
     * Set the picker to autofocus on mount.
     */
    autoFocus?: boolean;
    /**
     * The default for `isOpen`.
     */
    defaultIsOpen?: boolean;
    /**
     * The default for `value`.
     */
    defaultValue?: string;
    /**
     * A function for formatting the displayed time value in the input. By default parses with an internal time parser, and formats using the [date-fns format function]((https://date-fns.org/v1.29.0/docs/format))
     */
    formatDisplayLabel?: (time: string, timeFormat: string) => string;
    /**
     * The id of the field. Currently, react-select transforms this to have a `react-select-` prefix, and an `--input` suffix when applied to the input. For example, the id `my-input` would be transformed to `react-select-my-input--input`. Keep this in mind when needing to refer to the ID. This will be fixed in an upcoming release.
     */
    id?: string;
    /**
     * Props to apply to the container. *
     */
    innerProps?: React.AllHTMLAttributes<HTMLElement>;
    /**
     * Set if the field is disabled.
     */
    isDisabled?: boolean;
    /**
     * Set if the dropdown is open. Will be `false` if not provided.
     */
    isOpen?: boolean;
    /**
     * The name of the field.
     */
    name?: string;
    /**
     * Called when the field is blurred.
     */
    onBlur?: React.FocusEventHandler<HTMLElement>;
    /**
     * Called when the value changes. The only argument is an ISO time or empty string.
     */
    onChange?: (value: string) => void;
    /**
     * Called when the field is focused.
     */
    onFocus?: React.FocusEventHandler<HTMLElement>;
    parseInputValue?: (time: string, timeFormat: string) => string | Date;
    /**
     * Props to apply to the select.
     */
    selectProps?: SelectProps<any>;
    /**
     * The spacing for the select control.
     *
     * Compact is `gridSize() * 4`, default is `gridSize * 5`.
     */
    spacing?: Spacing;
    /**
     * The times shown in the dropdown.
     */
    times?: string[];
    /**
     * Set if users can edit the input, allowing them to add custom times.
     */
    timeIsEditable?: boolean;
    /**
     * The ISO time that should be used as the input value.
     */
    value?: string;
    /**
     * Set if the picker has an invalid value.
     */
    isInvalid?: boolean;
    /**
     * Hides icon for dropdown indicator.
     */
    hideIcon?: boolean;
    /**
     * Time format that is accepted by [date-fns's format function](https://date-fns.org/v1.29.0/docs/format).
     */
    timeFormat?: string;
    /**
     * Placeholder text displayed in input.
     */
    placeholder?: string;
    /**
     * Locale used to format the time. See [DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat).
     */
    locale?: string;
    /**
     * A `testId` prop is provided for specified elements, which is a unique string that appears as a data attribute `data-testid` in the rendered code, serving as a hook for automated tests:
     *  - `{testId}--container` wrapping element of time-picker
     */
    testId?: string;
}
type TimePickerProps = typeof timePickerDefaultProps & TimePickerBaseProps;
interface State {
    isOpen: boolean;
    /**
     * When being cleared from the icon the TimePicker is blurred.
     * This variable defines whether the default onMenuOpen or onMenuClose
     * events should behave as normal
     */
    clearingFromIcon: boolean;
    value: string;
    isFocused: boolean;
    l10n: LocalizationProvider;
}
declare const timePickerDefaultProps: {
    appearance: Appearance;
    autoFocus: boolean;
    defaultIsOpen: boolean;
    defaultValue: string;
    hideIcon: boolean;
    id: string;
    innerProps: {};
    isDisabled: boolean;
    isInvalid: boolean;
    name: string;
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    parseInputValue: (time: string, timeFormat: string) => string | Date;
    selectProps: {};
    spacing: Spacing;
    times: string[];
    timeIsEditable: boolean;
    locale: string;
};
declare class TimePicker extends React.Component<TimePickerProps, State> {
    containerRef: HTMLElement | null;
    static defaultProps: {
        appearance: Appearance;
        autoFocus: boolean;
        defaultIsOpen: boolean;
        defaultValue: string;
        hideIcon: boolean;
        id: string;
        innerProps: {};
        isDisabled: boolean;
        isInvalid: boolean;
        name: string;
        onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
        onChange: (value: string) => void;
        onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
        parseInputValue: (time: string, timeFormat: string) => string | Date;
        selectProps: {};
        spacing: Spacing;
        times: string[];
        timeIsEditable: boolean;
        locale: string;
    };
    state: {
        isOpen: boolean;
        clearingFromIcon: boolean;
        value: string;
        isFocused: boolean;
        l10n: LocalizationProvider;
    };
    UNSAFE_componentWillReceiveProps(nextProps: TimePickerProps): void;
    getSafeState: () => State;
    getOptions(): Array<Option>;
    onChange: (newValue: ValueType<OptionType> | string, action?: ActionMeta<OptionType>) => void;
    /**
     * Only allow custom times if timeIsEditable prop is true
     */
    onCreateOption: (inputValue: string) => void;
    onMenuOpen: () => void;
    onMenuClose: () => void;
    setContainerRef: (ref: HTMLElement | null) => void;
    onBlur: (event: React.FocusEvent<HTMLElement>) => void;
    onFocus: (event: React.FocusEvent<HTMLElement>) => void;
    onSelectKeyDown: (event: React.KeyboardEvent<HTMLInputElement>) => void;
    /**
     * There are multiple props that can change how the time is formatted.
     * The priority of props used is:
     *   1. formatDisplayLabel
     *   2. timeFormat
     *   3. locale
     */
    formatTime: (time: string) => string;
    getPlaceholder: () => string;
    render(): JSX.Element;
}
export { TimePicker as TimePickerWithoutAnalytics };
declare const _default: React.ForwardRefExoticComponent<Pick<Pick<Omit<TimePickerProps, keyof WithAnalyticsEventsProps>, "testId" | "isOpen" | "formatDisplayLabel" | "value" | "placeholder" | "timeFormat"> & Partial<Pick<Omit<TimePickerProps, keyof WithAnalyticsEventsProps>, "times" | "appearance" | "autoFocus" | "defaultIsOpen" | "defaultValue" | "id" | "innerProps" | "isDisabled" | "name" | "onBlur" | "onChange" | "onFocus" | "parseInputValue" | "selectProps" | "spacing" | "isInvalid" | "hideIcon" | "locale" | "timeIsEditable">> & Partial<Pick<{
    appearance: Appearance;
    autoFocus: boolean;
    defaultIsOpen: boolean;
    defaultValue: string;
    hideIcon: boolean;
    id: string;
    innerProps: {};
    isDisabled: boolean;
    isInvalid: boolean;
    name: string;
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    parseInputValue: (time: string, timeFormat: string) => string | Date;
    selectProps: {};
    spacing: Spacing;
    times: string[];
    timeIsEditable: boolean;
    locale: string;
}, never>> & React.RefAttributes<any> & import("@atlaskit/analytics-next").WithContextProps, "times" | "testId" | "appearance" | "autoFocus" | "defaultIsOpen" | "defaultValue" | "id" | "innerProps" | "isDisabled" | "isOpen" | "name" | "onBlur" | "onChange" | "onFocus" | "parseInputValue" | "formatDisplayLabel" | "selectProps" | "spacing" | "value" | "isInvalid" | "hideIcon" | "placeholder" | "locale" | "key" | "analyticsContext" | "timeIsEditable" | "timeFormat"> & React.RefAttributes<any>>;
export default _default;
