/** @jsx jsx */
import React from 'react';
import { jsx } from '@emotion/react';
import { WithAnalyticsEventsProps } from '@atlaskit/analytics-next';
import { SelectProps } from '@atlaskit/select';
import { Appearance, Spacing } from '../types';
import { DatePickerBaseProps as DatePickerProps } from './date-picker';
import { TimePickerBaseProps as TimePickerProps } from './time-picker';
export interface DateTimePickerBaseProps extends WithAnalyticsEventsProps {
    /**
     * Set the appearance of the picker.
     *
     * `subtle` will remove the borders and background.
     */
    appearance?: Appearance;
    /**
     * Set the picker to autofocus on mount.
     */
    autoFocus?: boolean;
    /**
     * The default for `value`.
     */
    defaultValue?: string;
    /**
     * The id of the field. Currently, react-select transforms this to have a `react-select-` prefix, and an `--input` suffix when applied to the input. For example, the id `my-input` would be transformed to `react-select-my-input--input`.
     * Keep this in mind when needing to refer to the ID. This will be fixed in an upcoming release.
     */
    id?: string;
    /**
     * Props to apply to the container. *
     */
    innerProps?: React.AllHTMLAttributes<HTMLElement>;
    /**
     * Set if the field is disabled.
     */
    isDisabled?: boolean;
    /**
     * The name of the field.
     */
    name?: string;
    /**
     * Called when the field is blurred.
     */
    onBlur?: React.FocusEventHandler<HTMLInputElement>;
    /**
     * Called when the value changes and the date / time is a complete value, or empty. The only value is an ISO string or empty string.
     */
    onChange?: (value: string) => void;
    /**
     * Called when the field is focused.
     */
    onFocus?: React.FocusEventHandler<HTMLInputElement>;
    /**
     * The ISO time that should be used as the input value.
     */
    value?: string;
    /**
     * Set if users can edit the input, allowing them to add custom times.
     */
    timeIsEditable?: boolean;
    /**
     * Set if the picker has an invalid value.
     */
    isInvalid?: boolean;
    /**
     * Format the date with a string that is accepted by [date-fns's format function](https://date-fns.org/v1.29.0/docs/format).
     */
    dateFormat?: string;
    /**
     * Props applied to the `DatePicker`.
     */
    datePickerProps?: DatePickerProps;
    /**
     * Props applied to the `TimePicker`.
     */
    timePickerProps?: TimePickerProps;
    /**
     * Function used to parse datetime values into their date, time and timezone sub-values. *
     */
    parseValue?: (dateTimeValue: string, date: string, time: string, timezone: string) => {
        dateValue: string;
        timeValue: string;
        zoneValue: string;
    };
    /**
     * [Select props](/components/select) to pass onto the `DatePicker` component's `Select`. This can be used to set options such as placeholder text.
     */
    datePickerSelectProps?: SelectProps<any>;
    /**
     * [Select props](/components/select) to pass onto the `TimePicker` component's `Select`. This can be used to set options such as placeholder text.
     */
    timePickerSelectProps?: SelectProps<any>;
    /**
     * The times shown by the `TimePicker`.
     */
    times?: Array<string>;
    /**
     * The format that times are displayed in. Values should be those accepted by [date-fns's format function](https://date-fns.org/v1.29.0/docs/format).
     */
    timeFormat?: string;
    /**
     * The spacing for the select control.
     *
     * Compact is `gridSize() * 4`, default is `gridSize() * 5`.
     */
    spacing?: Spacing;
    /**
     * Locale used for formatting dates and times. See [DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/DateTimeFormat).
     */
    locale?: string;
    /**
     * A `testId` prop is provided for specified elements, which is a unique string that appears as a data attribute `data-testid` in the rendered code, serving as a hook for automated tests
     *  - `{testId}--datepicker--container` wrapping element of date-picker
     *  - `{testId}--timepicker--container` wrapping element of time-picker
     */
    testId?: string;
}
type DateTimePickerProps = typeof dateTimePickerDefaultProps & DateTimePickerBaseProps;
interface State {
    active: 0 | 1 | 2;
    dateValue: string;
    isFocused: boolean;
    timeValue: string;
    value: string;
    zoneValue: string;
}
declare const dateTimePickerDefaultProps: {
    appearance: string;
    autoFocus: boolean;
    isDisabled: boolean;
    name: string;
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    innerProps: {};
    id: string;
    defaultValue: string;
    timeIsEditable: boolean;
    isInvalid: boolean;
    datePickerProps: {};
    timePickerProps: {};
    datePickerSelectProps: {};
    timePickerSelectProps: {};
    times: string[];
    spacing: string;
    locale: string;
};
export declare const datePickerDefaultAriaLabel = "Date";
export declare const timePickerDefaultAriaLabel = "Time";
declare class DateTimePicker extends React.Component<DateTimePickerProps, State> {
    static defaultProps: {
        appearance: string;
        autoFocus: boolean;
        isDisabled: boolean;
        name: string;
        onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
        onChange: (value: string) => void;
        onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
        innerProps: {};
        id: string;
        defaultValue: string;
        timeIsEditable: boolean;
        isInvalid: boolean;
        datePickerProps: {};
        timePickerProps: {};
        datePickerSelectProps: {};
        timePickerSelectProps: {};
        times: string[];
        spacing: string;
        locale: string;
    };
    state: State;
    getSafeState: () => {
        dateValue: string;
        timeValue: string;
        zoneValue: string;
        value: string;
        active: 0 | 1 | 2;
        isFocused: boolean;
    };
    parseValue(value: string, dateValue: string, timeValue: string, zoneValue: string): {
        dateValue: string;
        timeValue: string;
        zoneValue: string;
    };
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    onDateChange: (dateValue: string) => void;
    onTimeChange: (timeValue: string) => void;
    onClear: () => void;
    onValueChange({ dateValue, timeValue, zoneValue, }: {
        dateValue: string;
        timeValue: string;
        zoneValue: string;
    }): void;
    render(): jsx.JSX.Element;
}
export { DateTimePicker as DateTimePickerWithoutAnalytics };
declare const _default: React.ForwardRefExoticComponent<Pick<Pick<Omit<DateTimePickerProps, keyof WithAnalyticsEventsProps>, "testId" | "value" | "dateFormat" | "timeFormat" | "parseValue"> & Partial<Pick<Omit<DateTimePickerProps, keyof WithAnalyticsEventsProps>, "times" | "appearance" | "autoFocus" | "defaultValue" | "id" | "innerProps" | "isDisabled" | "name" | "onBlur" | "onChange" | "onFocus" | "spacing" | "isInvalid" | "locale" | "timeIsEditable" | "datePickerProps" | "timePickerProps" | "datePickerSelectProps" | "timePickerSelectProps">> & Partial<Pick<{
    appearance: string;
    autoFocus: boolean;
    isDisabled: boolean;
    name: string;
    onBlur: (event: React.FocusEvent<HTMLInputElement>) => void;
    onChange: (value: string) => void;
    onFocus: (event: React.FocusEvent<HTMLInputElement>) => void;
    innerProps: {};
    id: string;
    defaultValue: string;
    timeIsEditable: boolean;
    isInvalid: boolean;
    datePickerProps: {};
    timePickerProps: {};
    datePickerSelectProps: {};
    timePickerSelectProps: {};
    times: string[];
    spacing: string;
    locale: string;
}, never>> & React.RefAttributes<any> & import("@atlaskit/analytics-next").WithContextProps, "times" | "testId" | "appearance" | "autoFocus" | "defaultValue" | "id" | "innerProps" | "isDisabled" | "name" | "onBlur" | "onChange" | "onFocus" | "spacing" | "value" | "isInvalid" | "dateFormat" | "locale" | "key" | "analyticsContext" | "timeIsEditable" | "timeFormat" | "datePickerProps" | "timePickerProps" | "parseValue" | "datePickerSelectProps" | "timePickerSelectProps"> & React.RefAttributes<any>>;
export default _default;
