import React from 'react';
interface FixedLayerProps {
    /**
     * A ref to the container that the content should be layered around for height calculation
     * purposes. This must be an ancestor element as component does not attach the layered content around
     * the ref itself.
     */
    containerRef: HTMLElement | null;
    /**
     * The content to render in the layer.
     */
    content: React.ReactNode;
    /**
     * input value from the menu.
     */
    inputValue: string;
    /**
     * A `testId` prop is provided for specified elements, which is a unique string that appears as a data attribute `data-testid` in the rendered code, serving as a hook for automated tests
     *  - `{testId}--popper-container` wrapping element of time-picker
     */
    testId?: string;
}
/**
 * This component renders layered content with fixed positioning.
 * Scroll is locked outside the layer to prevent the layered content from detaching from the
 * container ref.
 */
export default class FixedLayer extends React.Component<FixedLayerProps> {
    update: () => void;
    componentDidUpdate(prevProps: any): void;
    render(): JSX.Element;
}
export {};
