"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _blanket = _interopRequireDefault(require("@atlaskit/blanket"));
var _motion = require("@atlaskit/motion");
var _constants = require("../constants");
/** @jsx jsx */

var blanketStyles = (0, _react2.css)({
  position: 'relative'
});

/**
 * A wrapper around `@atlaskit/blanket` that adds a fade in/out transition.
 */
var Blanket = function Blanket(_ref) {
  var isOpen = _ref.isOpen,
    onBlanketClicked = _ref.onBlanketClicked,
    testId = _ref.testId;
  return (0, _react2.jsx)(_motion.ExitingPersistence, {
    appear: true
  }, isOpen && (0, _react2.jsx)(_motion.FadeIn
  /**
   * We double the duration because the fade in keyframes have
   * `opacity: 1` at `50%`.
   *
   * The fade out animation uses half the passed duration so it evens out.
   */, {
    duration: _constants.transitionDurationMs * 2
    /**
     * We don't expose this on `FadeIn` but it does get passed down.
     * TODO: figure out how we want to handle this...
     */
    // @ts-ignore
    ,
    animationTimingFunction: _constants.animationTimingFunction
  }, function (_ref2) {
    var className = _ref2.className;
    return (0, _react2.jsx)("div", {
      css: blanketStyles,
      className: className
    }, (0, _react2.jsx)(_blanket.default, {
      isTinted: true,
      onBlanketClicked: onBlanketClicked,
      testId: testId && testId
    }));
  }));
};
var _default = Blanket;
exports.default = _default;