"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DrawerBase = void 0;
var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));
var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));
var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));
var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));
var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));
var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _exenv = require("exenv");
var _analyticsNext = require("@atlaskit/analytics-next");
var _portal = _interopRequireDefault(require("@atlaskit/portal"));
var _constants = require("../constants");
var _blanket = _interopRequireDefault(require("./blanket"));
var _primitives = _interopRequireDefault(require("./primitives"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } } /* eslint-disable @repo/internal/dom-events/no-unsafe-event-listeners */
var packageName = "@atlaskit/drawer";
var packageVersion = "7.5.3";
var createAndFireEventOnAtlaskit = (0, _analyticsNext.createAndFireEvent)('atlaskit');
var createAndFireOnClick = function createAndFireOnClick(createAnalyticsEvent, trigger) {
  return createAndFireEventOnAtlaskit({
    action: 'dismissed',
    actionSubject: 'drawer',
    attributes: {
      componentName: 'drawer',
      packageName: packageName,
      packageVersion: packageVersion,
      trigger: trigger
    }
  })(createAnalyticsEvent);
};
var DrawerBase = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(DrawerBase, _Component);
  var _super = _createSuper(DrawerBase);
  function DrawerBase() {
    var _this;
    (0, _classCallCheck2.default)(this, DrawerBase);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      renderPortal: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "body", _exenv.canUseDOM ? document.querySelector('body') : undefined);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleBlanketClick", function (event) {
      _this.handleClose(event, 'blanket');
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleBackButtonClick", function (event) {
      _this.handleClose(event, 'backButton');
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClose", function (event, trigger) {
      var _this$props = _this.props,
        createAnalyticsEvent = _this$props.createAnalyticsEvent,
        onClose = _this$props.onClose;
      var analyticsEvent = createAnalyticsEvent && createAndFireOnClick(createAnalyticsEvent, trigger);
      if (onClose) {
        onClose(event, analyticsEvent);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleKeyDown", function (event) {
      var _this$props2 = _this.props,
        isOpen = _this$props2.isOpen,
        onKeyDown = _this$props2.onKeyDown;
      if (event.key === 'Escape' && isOpen) {
        _this.handleClose(event, 'escKey');
      }
      if (onKeyDown) {
        onKeyDown(event);
      }
    });
    return _this;
  }
  (0, _createClass2.default)(DrawerBase, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var isOpen = this.props.isOpen;
      if (isOpen) {
        window.addEventListener('keydown', this.handleKeyDown);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('keydown', this.handleKeyDown);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var isOpen = this.props.isOpen;
      if (isOpen !== prevProps.isOpen) {
        if (isOpen) {
          window.addEventListener('keydown', this.handleKeyDown);
        } else {
          window.removeEventListener('keydown', this.handleKeyDown);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      if (!this.body) {
        return null;
      }
      var _this$props3 = this.props,
        testId = _this$props3.testId,
        isOpen = _this$props3.isOpen,
        children = _this$props3.children,
        icon = _this$props3.icon,
        width = _this$props3.width,
        shouldUnmountOnExit = _this$props3.shouldUnmountOnExit,
        onCloseComplete = _this$props3.onCloseComplete,
        onOpenComplete = _this$props3.onOpenComplete,
        autoFocusFirstElem = _this$props3.autoFocusFirstElem,
        isFocusLockEnabled = _this$props3.isFocusLockEnabled,
        shouldReturnFocus = _this$props3.shouldReturnFocus,
        overrides = _this$props3.overrides,
        _this$props3$zIndex = _this$props3.zIndex,
        zIndex = _this$props3$zIndex === void 0 ? 'unset' : _this$props3$zIndex;
      return /*#__PURE__*/_react.default.createElement(_portal.default, {
        zIndex: zIndex
      }, /*#__PURE__*/_react.default.createElement(_blanket.default, {
        isOpen: isOpen,
        onBlanketClicked: this.handleBlanketClick,
        testId: testId && "".concat(testId, "--blanket")
      }), /*#__PURE__*/_react.default.createElement(_primitives.default, {
        testId: testId,
        icon: icon,
        in: isOpen,
        onClose: this.handleBackButtonClick,
        onCloseComplete: onCloseComplete,
        onOpenComplete: onOpenComplete,
        width: width,
        shouldUnmountOnExit: shouldUnmountOnExit
        // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
        ,
        overrides: overrides,
        autoFocusFirstElem: autoFocusFirstElem,
        isFocusLockEnabled: isFocusLockEnabled,
        shouldReturnFocus: shouldReturnFocus
      }, children));
    }
  }]);
  return DrawerBase;
}(_react.Component);
exports.DrawerBase = DrawerBase;
(0, _defineProperty2.default)(DrawerBase, "defaultProps", _objectSpread({
  width: 'narrow'
}, _constants.defaultFocusLockSettings));
var _default = (0, _analyticsNext.withAnalyticsContext)({
  componentName: 'drawer',
  packageName: packageName,
  packageVersion: packageVersion
})((0, _analyticsNext.withAnalyticsEvents)()(DrawerBase));
exports.default = _default;