"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("@emotion/react");
var _excluded = ["cssFn"];
/** @jsx jsx */
var defaultStyles = {
  flex: 1,
  overflow: 'auto',
  marginTop: "var(--ds-space-300, 24px)"
};
var contentCSS = function contentCSS() {
  return defaultStyles;
};
var Content = function Content(_ref) {
  var cssFn = _ref.cssFn,
    props = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return (
    /**
     * I noticed the implementation at @atlaskit/checkbox would send the props to cssFn rather
     * than the defaultStyles as the overrides guide suggests. I went with what the overrides
     * guide suggested as it made more sense as a transformer of the current styles rather than
     * a complete override with no chance of partially changing styles.
     */

    // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage, @repo/internal/react/no-unsafe-spread-props
    (0, _react.jsx)("div", (0, _extends2.default)({
      css: (0, _react.css)(cssFn(defaultStyles))
    }, props))
  );
};
var _default = {
  component: Content,
  cssFn: contentCSS
};
exports.default = _default;