"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.wrapperWidth = exports.default = void 0;
var _react = require("react");
var _react2 = require("@emotion/react");
var _useCallbackRef = require("use-callback-ref");
var _colors = require("@atlaskit/theme/colors");
var _usePreventProgrammaticScroll = _interopRequireDefault(require("./hooks/use-prevent-programmatic-scroll"));
/** @jsx jsx */

var wrapperWidth = {
  full: {
    width: '100vw'
  },
  extended: {
    width: '95vw'
  },
  narrow: {
    width: 360
  },
  medium: {
    width: 480
  },
  wide: {
    width: 600
  }
};
exports.wrapperWidth = wrapperWidth;
var wrapperStyles = (0, _react2.css)({
  display: 'flex',
  height: '100vh',
  position: 'fixed',
  zIndex: 500,
  top: 0,
  left: 0,
  backgroundColor: "var(--ds-surface-overlay, ".concat(_colors.N0, ")"),
  overflow: 'hidden'
});
/**
 * A wrapper that controls the styling of the drawer with a few hacks with refs to get our Touch±Scroll locks working.
 */
var DrawerWrapper = /*#__PURE__*/(0, _react.forwardRef)(function (_ref, scrollRef) {
  var children = _ref.children,
    className = _ref.className,
    _ref$width = _ref.width,
    width = _ref$width === void 0 ? 'narrow' : _ref$width,
    testId = _ref.testId,
    drawerRef = _ref.drawerRef;
  /**
   * We use a callback ref to assign the `<Content />` component to the forwarded `scrollRef`.
   * This ref comes from `react-scrolllock` to allow touch scrolling, eg.: `<ScrollLock><TouchScrollable>{children}</TouchScrollable><ScrollLock>`
   *
   * This is because we do not control the `<Content />` component in order to forward a ref to it (given it can be overriden via `DrawerPrimitiveProps['overrides']['Content']['component']`).
   * Additionally, we target the last child because with `props.overrides.Sidebar.component = () => null` you only have one child.
   * If both `Sidebar.component` and `Content.component` return null you will have no children and this will throw an error, but that doesn't seem valid.
   */
  var assignSecondChildRef = (0, _react.useCallback)(function (node) {
    var _node$children;
    if (node !== null && node !== void 0 && (_node$children = node.children) !== null && _node$children !== void 0 && _node$children.length && typeof scrollRef === 'function') {
      scrollRef(node.children[node.children.length - 1]);
    }
  }, [scrollRef]);
  var ref = (0, _useCallbackRef.useMergeRefs)([drawerRef, assignSecondChildRef]);
  (0, _usePreventProgrammaticScroll.default)();
  return (0, _react2.jsx)("div", {
    css: wrapperStyles,
    style: wrapperWidth[width],
    className: className,
    "data-testid": testId,
    ref: ref
  }, children);
});
var _default = DrawerWrapper;
exports.default = _default;