"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _colors = require("@atlaskit/theme/colors");
/** @jsx jsx */

var iconButtonStyles = (0, _react.css)({
  padding: "var(--ds-space-100, 8px)",
  backgroundColor: 'inherit',
  border: 'none',
  borderRadius: "var(--ds-space-1000, 80px)",
  color: 'inherit',
  cursor: 'pointer',
  lineHeight: "var(--ds-font-lineHeight-100, 1)",
  '&:hover': {
    backgroundColor: "var(--ds-background-neutral-subtle-hovered, ".concat(_colors.N30A, ")")
  },
  '&:active': {
    backgroundColor: "var(--ds-background-neutral-subtle-pressed, ".concat(_colors.B50, ")")
  }
});
var IconButton = function IconButton(_ref) {
  var children = _ref.children,
    onClick = _ref.onClick,
    testId = _ref.testId;
  return (0, _react.jsx)("button", {
    type: "button",
    css: iconButtonStyles,
    onClick: onClick,
    "data-testid": testId
  }, children);
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var _default = IconButton;
exports.default = _default;