"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = require("react");
var _react2 = require("@emotion/react");
var _arrowLeft = _interopRequireDefault(require("@atlaskit/icon/glyph/arrow-left"));
var _motion = require("@atlaskit/motion");
var _constants = require("../../constants");
var _utils = require("../utils");
var _content = _interopRequireDefault(require("./content"));
var _drawerWrapper = _interopRequireDefault(require("./drawer-wrapper"));
var _focusLock = _interopRequireDefault(require("./focus-lock"));
var _iconButton = _interopRequireDefault(require("./icon-button"));
var _sidebar = _interopRequireDefault(require("./sidebar"));
var _excluded = ["component"],
  _excluded2 = ["component"];
/** @jsx jsx */
// Misc.
// ------------------------------
var defaults = {
  Sidebar: _sidebar.default,
  Content: _content.default
};

/**
 * This wrapper is used to specify separate durations for enter and exit.
 */
var CustomSlideIn = function CustomSlideIn(_ref) {
  var children = _ref.children,
    onFinish = _ref.onFinish;
  var _useExitingPersistenc = (0, _motion.useExitingPersistence)(),
    isExiting = _useExitingPersistenc.isExiting;

  /**
   * The actual duration should be the same for both enter and exit,
   * but motion halves the passed duration for exit animations,
   * so we double it when exiting.
   */
  var duration = isExiting ? _constants.transitionDurationMs * 2 : _constants.transitionDurationMs;
  return (0, _react2.jsx)(_motion.SlideIn, {
    animationTimingFunction: _constants.animationTimingFunction,
    duration: duration,
    enterFrom: "left",
    exitTo: "left",
    fade: "none",
    onFinish: onFinish
  }, children);
};
var DrawerPrimitive = function DrawerPrimitive(_ref2) {
  var children = _ref2.children,
    Icon = _ref2.icon,
    onClose = _ref2.onClose,
    onCloseComplete = _ref2.onCloseComplete,
    onOpenComplete = _ref2.onOpenComplete,
    overrides = _ref2.overrides,
    testId = _ref2.testId,
    isOpen = _ref2.in,
    shouldReturnFocus = _ref2.shouldReturnFocus,
    autoFocusFirstElem = _ref2.autoFocusFirstElem,
    isFocusLockEnabled = _ref2.isFocusLockEnabled,
    width = _ref2.width;
  var getOverrides = (0, _utils.createExtender)(defaults, overrides);
  var _getOverrides = getOverrides('Sidebar'),
    Sidebar = _getOverrides.component,
    sideBarOverrides = (0, _objectWithoutProperties2.default)(_getOverrides, _excluded);
  var _getOverrides2 = getOverrides('Content'),
    Content = _getOverrides2.component,
    contentOverrides = (0, _objectWithoutProperties2.default)(_getOverrides2, _excluded2);

  /**
   * A ref to point to our wrapper, passed to `onCloseComplete` and `onOpenComplete` callbacks.
   */
  var drawerRef = (0, _react.useRef)(null);
  var onFinish = (0, _react.useCallback)(function (state) {
    if (state === 'entering') {
      onOpenComplete === null || onOpenComplete === void 0 ? void 0 : onOpenComplete(drawerRef.current);
    } else if (state === 'exiting') {
      onCloseComplete === null || onCloseComplete === void 0 ? void 0 : onCloseComplete(drawerRef.current);
    }
  }, [onCloseComplete, onOpenComplete]);
  return (0, _react2.jsx)(_motion.ExitingPersistence, {
    appear: true
  }, isOpen && (0, _react2.jsx)(CustomSlideIn, {
    onFinish: onFinish
  }, function (_ref3) {
    var className = _ref3.className;
    return (0, _react2.jsx)(_focusLock.default, {
      autoFocusFirstElem: autoFocusFirstElem,
      isFocusLockEnabled: isFocusLockEnabled,
      shouldReturnFocus: shouldReturnFocus
    }, (0, _react2.jsx)(_drawerWrapper.default, {
      className: className,
      width: width,
      testId: testId,
      drawerRef: drawerRef
    }, (0, _react2.jsx)(Sidebar, sideBarOverrides, (0, _react2.jsx)(_iconButton.default, {
      onClick: onClose,
      testId: testId && 'DrawerPrimitiveSidebarCloseButton'
    }, Icon ? (0, _react2.jsx)(Icon, {
      size: "large"
    }) : (0, _react2.jsx)(_arrowLeft.default, {
      label: "Close drawer"
    }))), (0, _react2.jsx)(Content, contentOverrides, children)));
  }));
};

// eslint-disable-next-line @repo/internal/react/require-jsdoc
var _default = DrawerPrimitive;
exports.default = _default;