import _defineProperty from "@babel/runtime/helpers/defineProperty";
/* eslint-disable @repo/internal/dom-events/no-unsafe-event-listeners */
import React, { Component } from 'react';
import { canUseDOM } from 'exenv';
import { createAndFireEvent, withAnalyticsContext, withAnalyticsEvents } from '@atlaskit/analytics-next';
import Portal from '@atlaskit/portal';
import { defaultFocusLockSettings } from '../constants';
import Blanket from './blanket';
import DrawerPrimitive from './primitives';
const packageName = "@atlaskit/drawer";
const packageVersion = "7.5.3";
const createAndFireEventOnAtlaskit = createAndFireEvent('atlaskit');
const createAndFireOnClick = (createAnalyticsEvent, trigger) => createAndFireEventOnAtlaskit({
  action: 'dismissed',
  actionSubject: 'drawer',
  attributes: {
    componentName: 'drawer',
    packageName,
    packageVersion,
    trigger
  }
})(createAnalyticsEvent);
export class DrawerBase extends Component {
  constructor(...args) {
    super(...args);
    _defineProperty(this, "state", {
      renderPortal: false
    });
    _defineProperty(this, "body", canUseDOM ? document.querySelector('body') : undefined);
    _defineProperty(this, "handleBlanketClick", event => {
      this.handleClose(event, 'blanket');
    });
    _defineProperty(this, "handleBackButtonClick", event => {
      this.handleClose(event, 'backButton');
    });
    _defineProperty(this, "handleClose", (event, trigger) => {
      const {
        createAnalyticsEvent,
        onClose
      } = this.props;
      const analyticsEvent = createAnalyticsEvent && createAndFireOnClick(createAnalyticsEvent, trigger);
      if (onClose) {
        onClose(event, analyticsEvent);
      }
    });
    _defineProperty(this, "handleKeyDown", event => {
      const {
        isOpen,
        onKeyDown
      } = this.props;
      if (event.key === 'Escape' && isOpen) {
        this.handleClose(event, 'escKey');
      }
      if (onKeyDown) {
        onKeyDown(event);
      }
    });
  }
  componentDidMount() {
    const {
      isOpen
    } = this.props;
    if (isOpen) {
      window.addEventListener('keydown', this.handleKeyDown);
    }
  }
  componentWillUnmount() {
    window.removeEventListener('keydown', this.handleKeyDown);
  }
  componentDidUpdate(prevProps) {
    const {
      isOpen
    } = this.props;
    if (isOpen !== prevProps.isOpen) {
      if (isOpen) {
        window.addEventListener('keydown', this.handleKeyDown);
      } else {
        window.removeEventListener('keydown', this.handleKeyDown);
      }
    }
  }
  render() {
    if (!this.body) {
      return null;
    }
    const {
      testId,
      isOpen,
      children,
      icon,
      width,
      shouldUnmountOnExit,
      onCloseComplete,
      onOpenComplete,
      autoFocusFirstElem,
      isFocusLockEnabled,
      shouldReturnFocus,
      overrides,
      zIndex = 'unset'
    } = this.props;
    return /*#__PURE__*/React.createElement(Portal, {
      zIndex: zIndex
    }, /*#__PURE__*/React.createElement(Blanket, {
      isOpen: isOpen,
      onBlanketClicked: this.handleBlanketClick,
      testId: testId && `${testId}--blanket`
    }), /*#__PURE__*/React.createElement(DrawerPrimitive, {
      testId: testId,
      icon: icon,
      in: isOpen,
      onClose: this.handleBackButtonClick,
      onCloseComplete: onCloseComplete,
      onOpenComplete: onOpenComplete,
      width: width,
      shouldUnmountOnExit: shouldUnmountOnExit
      // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
      ,
      overrides: overrides,
      autoFocusFirstElem: autoFocusFirstElem,
      isFocusLockEnabled: isFocusLockEnabled,
      shouldReturnFocus: shouldReturnFocus
    }, children));
  }
}
_defineProperty(DrawerBase, "defaultProps", {
  width: 'narrow',
  ...defaultFocusLockSettings
});
export default withAnalyticsContext({
  componentName: 'drawer',
  packageName,
  packageVersion
})(withAnalyticsEvents()(DrawerBase));