import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { css, jsx } from '@emotion/react';
const defaultStyles = {
  flex: 1,
  overflow: 'auto',
  marginTop: "var(--ds-space-300, 24px)"
};
const contentCSS = () => defaultStyles;
const Content = ({
  cssFn,
  ...props
}) =>
/**
 * I noticed the implementation at @atlaskit/checkbox would send the props to cssFn rather
 * than the defaultStyles as the overrides guide suggests. I went with what the overrides
 * guide suggested as it made more sense as a transformer of the current styles rather than
 * a complete override with no chance of partially changing styles.
 */

// eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage, @repo/internal/react/no-unsafe-spread-props
jsx("div", _extends({
  css: css(cssFn(defaultStyles))
}, props));
export default {
  component: Content,
  cssFn: contentCSS
};