import _extends from "@babel/runtime/helpers/extends";
/** @jsx jsx */

import { css, jsx } from '@emotion/react';
import { N500 } from '@atlaskit/theme/colors';
const defaultStyle = {
  alignItems: 'center',
  boxSizing: 'border-box',
  color: `var(--ds-text-subtle, ${N500})`,
  display: 'flex',
  flexShrink: 0,
  flexDirection: 'column',
  height: '100vh',
  paddingBottom: "var(--ds-space-200, 16px)",
  paddingTop: "var(--ds-space-300, 24px)",
  width: "var(--ds-space-800, 64px)"
};
const sidebarCSS = () => defaultStyle;
const Sidebar = ({
  cssFn,
  ...props
}) => {
  // eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage, @repo/internal/react/no-unsafe-spread-props
  return jsx("div", _extends({
    css: css(cssFn(defaultStyle))
  }, props));
};
export default {
  component: Sidebar,
  cssFn: sidebarCSS
};