// eslint-disable-next-line @repo/internal/react/consistent-types-definitions

/**
 * @deprecated Please avoid using this function as we intend to remote it in a future release. See DSP-2673 for more information.
 */
export const createExtender = function createExtender(defaults,
/**
 * We're defaulting to an Object.create call here to circumvent
 *  the fact that {} can't be reconciled
 *  with a type that extends Record<string, any>
 *
 *  By doing this, we are intentionally disallowing users
 *  from nullifying a particular component in the tree.
 *  This can be reverted with additional logic,
 *  at such a time as this nullification becomes an actual usecase.
 */
overrides = Object.create(Object.prototype)) {
  if (!defaults) {
    throw new Error('a default set of overrides *must* be passed in as the first argument');
  }
  return function getOverrides(key) {
    const {
      cssFn: defaultCssFn,
      component: defaultComponent
    } = defaults[key];
    if (!overrides[key]) {
      return {
        cssFn: defaultCssFn,
        component: defaultComponent
      };
    }
    const {
      cssFn: customCssFn,
      component: customComponent
    } = overrides[key];
    const composedCssFn = state => {
      return customCssFn(defaultCssFn(state), state);
    };
    return {
      cssFn: customCssFn ? composedCssFn : defaultCssFn,
      component: customComponent || defaultComponent
    };
  };
};