import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
/* eslint-disable @repo/internal/dom-events/no-unsafe-event-listeners */
import React, { Component } from 'react';
import { canUseDOM } from 'exenv';
import { createAndFireEvent, withAnalyticsContext, withAnalyticsEvents } from '@atlaskit/analytics-next';
import Portal from '@atlaskit/portal';
import { defaultFocusLockSettings } from '../constants';
import Blanket from './blanket';
import DrawerPrimitive from './primitives';
var packageName = "@atlaskit/drawer";
var packageVersion = "7.5.3";
var createAndFireEventOnAtlaskit = createAndFireEvent('atlaskit');
var createAndFireOnClick = function createAndFireOnClick(createAnalyticsEvent, trigger) {
  return createAndFireEventOnAtlaskit({
    action: 'dismissed',
    actionSubject: 'drawer',
    attributes: {
      componentName: 'drawer',
      packageName: packageName,
      packageVersion: packageVersion,
      trigger: trigger
    }
  })(createAnalyticsEvent);
};
export var DrawerBase = /*#__PURE__*/function (_Component) {
  _inherits(DrawerBase, _Component);
  var _super = _createSuper(DrawerBase);
  function DrawerBase() {
    var _this;
    _classCallCheck(this, DrawerBase);
    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }
    _this = _super.call.apply(_super, [this].concat(args));
    _defineProperty(_assertThisInitialized(_this), "state", {
      renderPortal: false
    });
    _defineProperty(_assertThisInitialized(_this), "body", canUseDOM ? document.querySelector('body') : undefined);
    _defineProperty(_assertThisInitialized(_this), "handleBlanketClick", function (event) {
      _this.handleClose(event, 'blanket');
    });
    _defineProperty(_assertThisInitialized(_this), "handleBackButtonClick", function (event) {
      _this.handleClose(event, 'backButton');
    });
    _defineProperty(_assertThisInitialized(_this), "handleClose", function (event, trigger) {
      var _this$props = _this.props,
        createAnalyticsEvent = _this$props.createAnalyticsEvent,
        onClose = _this$props.onClose;
      var analyticsEvent = createAnalyticsEvent && createAndFireOnClick(createAnalyticsEvent, trigger);
      if (onClose) {
        onClose(event, analyticsEvent);
      }
    });
    _defineProperty(_assertThisInitialized(_this), "handleKeyDown", function (event) {
      var _this$props2 = _this.props,
        isOpen = _this$props2.isOpen,
        onKeyDown = _this$props2.onKeyDown;
      if (event.key === 'Escape' && isOpen) {
        _this.handleClose(event, 'escKey');
      }
      if (onKeyDown) {
        onKeyDown(event);
      }
    });
    return _this;
  }
  _createClass(DrawerBase, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      var isOpen = this.props.isOpen;
      if (isOpen) {
        window.addEventListener('keydown', this.handleKeyDown);
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('keydown', this.handleKeyDown);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var isOpen = this.props.isOpen;
      if (isOpen !== prevProps.isOpen) {
        if (isOpen) {
          window.addEventListener('keydown', this.handleKeyDown);
        } else {
          window.removeEventListener('keydown', this.handleKeyDown);
        }
      }
    }
  }, {
    key: "render",
    value: function render() {
      if (!this.body) {
        return null;
      }
      var _this$props3 = this.props,
        testId = _this$props3.testId,
        isOpen = _this$props3.isOpen,
        children = _this$props3.children,
        icon = _this$props3.icon,
        width = _this$props3.width,
        shouldUnmountOnExit = _this$props3.shouldUnmountOnExit,
        onCloseComplete = _this$props3.onCloseComplete,
        onOpenComplete = _this$props3.onOpenComplete,
        autoFocusFirstElem = _this$props3.autoFocusFirstElem,
        isFocusLockEnabled = _this$props3.isFocusLockEnabled,
        shouldReturnFocus = _this$props3.shouldReturnFocus,
        overrides = _this$props3.overrides,
        _this$props3$zIndex = _this$props3.zIndex,
        zIndex = _this$props3$zIndex === void 0 ? 'unset' : _this$props3$zIndex;
      return /*#__PURE__*/React.createElement(Portal, {
        zIndex: zIndex
      }, /*#__PURE__*/React.createElement(Blanket, {
        isOpen: isOpen,
        onBlanketClicked: this.handleBlanketClick,
        testId: testId && "".concat(testId, "--blanket")
      }), /*#__PURE__*/React.createElement(DrawerPrimitive, {
        testId: testId,
        icon: icon,
        in: isOpen,
        onClose: this.handleBackButtonClick,
        onCloseComplete: onCloseComplete,
        onOpenComplete: onOpenComplete,
        width: width,
        shouldUnmountOnExit: shouldUnmountOnExit
        // eslint-disable-next-line @repo/internal/react/no-unsafe-overrides
        ,
        overrides: overrides,
        autoFocusFirstElem: autoFocusFirstElem,
        isFocusLockEnabled: isFocusLockEnabled,
        shouldReturnFocus: shouldReturnFocus
      }, children));
    }
  }]);
  return DrawerBase;
}(Component);
_defineProperty(DrawerBase, "defaultProps", _objectSpread({
  width: 'narrow'
}, defaultFocusLockSettings));
export default withAnalyticsContext({
  componentName: 'drawer',
  packageName: packageName,
  packageVersion: packageVersion
})(withAnalyticsEvents()(DrawerBase));