import React, { Component } from 'react';
import { DrawerProps, DrawerWidth } from './types';
export declare class DrawerBase extends Component<DrawerProps, {
    renderPortal: boolean;
}> {
    static defaultProps: {
        autoFocusFirstElem?: boolean | (() => HTMLElement | null) | undefined;
        isFocusLockEnabled?: boolean | undefined;
        shouldReturnFocus?: boolean | undefined;
        width: DrawerWidth;
    };
    state: {
        renderPortal: boolean;
    };
    body: HTMLBodyElement | null | undefined;
    componentDidMount(): void;
    componentWillUnmount(): void;
    componentDidUpdate(prevProps: DrawerProps): void;
    private handleBlanketClick;
    private handleBackButtonClick;
    private handleClose;
    handleKeyDown: (event: KeyboardEvent) => void;
    render(): JSX.Element | null;
}
declare const _default: React.ForwardRefExoticComponent<Pick<Pick<Omit<DrawerProps, keyof import("@atlaskit/analytics-next").WithAnalyticsEventsProps>, "children" | "onKeyDown" | "onClose" | "testId" | "icon" | "onOpenComplete" | "onCloseComplete" | "shouldUnmountOnExit" | "overrides" | "zIndex" | "isOpen"> & Partial<Pick<Omit<DrawerProps, keyof import("@atlaskit/analytics-next").WithAnalyticsEventsProps>, "width" | keyof import("./types").FocusLockSettings>> & Partial<Pick<{
    autoFocusFirstElem?: boolean | (() => HTMLElement | null) | undefined;
    isFocusLockEnabled?: boolean | undefined;
    shouldReturnFocus?: boolean | undefined;
    width: DrawerWidth;
}, never>> & React.RefAttributes<any> & import("@atlaskit/analytics-next").WithContextProps, "width" | "children" | "onKeyDown" | "key" | "onClose" | "testId" | "icon" | "onOpenComplete" | "onCloseComplete" | "shouldUnmountOnExit" | "overrides" | "zIndex" | "isOpen" | "analyticsContext" | keyof import("./types").FocusLockSettings> & React.RefAttributes<any>>;
export default _default;
