/** @jsx jsx */
import { ReactElement, Ref } from 'react';
import { DrawerPrimitiveProps, Widths } from '../types';
export declare const wrapperWidth: Widths;
interface FocusLockRefTargetProps extends Pick<DrawerPrimitiveProps, 'width' | 'testId'> {
    /**
     * This must have two children explicitly as we target the second child as the Content.
     */
    children: [ReactElement, ReactElement];
    /**
     * A ref pointing to our drawer wrapper, passed to `onCloseComplete` and `onOpenComplete` callbacks.
     */
    drawerRef: Ref<HTMLDivElement>;
    /**
     * The className coming from the SlideIn render callback.
     */
    className?: string;
}
/**
 * A wrapper that controls the styling of the drawer with a few hacks with refs to get our Touch±Scroll locks working.
 */
declare const DrawerWrapper: import("react").ForwardRefExoticComponent<FocusLockRefTargetProps & import("react").RefAttributes<HTMLElement>>;
export default DrawerWrapper;
