/**
 * Assigns the node to all the refs passed in the argument.
 *
 * @param refs: An array of refs (as function or ref object)
 */
export default function mergeRefs(refs) {
  return value => {
    refs.forEach(ref => {
      if (typeof ref === 'function') {
        ref(value);
      } else if (ref !== null) {
        ref.current = value;
      }
    });
  };
}