interface UseCloseOnEscapePressOpts {
    onClose: (e: KeyboardEvent) => void;
    isDisabled?: boolean;
}
/**
 * Calls back when the escape key is pressed.
 * To be used exclusively for closing layered components.
 * Use the `isDisabled` argument to ignore closing events.
 *
 * ```js
 * useCloseOnEscapePress({
 *   onClose: () => {},
 *   isDisabled: false,
 * });
 * ```
 */
export default function useCloseOnEscapePress({ onClose, isDisabled, }: UseCloseOnEscapePressOpts): void;
export {};
