"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _constants = require("@atlaskit/theme/constants");
/** @jsx jsx */

// eslint-disable-next-line @atlaskit/design-system/no-deprecated-imports

var gridSize = (0, _constants.gridSize)();
var verticalMarginSize = "var(--ds-space-600, 48px)";
var columnWidth = gridSize * 8;
var gutter = gridSize * 2;
var containerStyles = (0, _react.css)({
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  margin: "".concat(verticalMarginSize, " auto"),
  textAlign: 'center'
});

/* Use max-width so the component can shrink on smaller viewports. */
var wideContainerStyles = (0, _react.css)({
  maxWidth: "".concat(columnWidth * 6 + gutter * 5, "px")
});
var narrowContainerStyles = (0, _react.css)({
  maxWidth: "".concat(columnWidth * 4 + gutter * 3, "px")
});
/**
 * __Container__
 *
 * Upper level container for Empty State.
 *
 * @internal
 */
var Container = function Container(_ref) {
  var children = _ref.children,
    width = _ref.width,
    testId = _ref.testId;
  return (0, _react.jsx)("div", {
    "data-testid": testId,
    css: [containerStyles, width === 'narrow' ? narrowContainerStyles : wideContainerStyles]
  }, children);
};
var _default = Container;
exports.default = _default;