"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = require("@emotion/react");
var _typography = require("@atlaskit/theme/typography");
/** @jsx jsx */

// eslint-disable-next-line @atlaskit/design-system/consistent-css-prop-usage
var headerStyles = (0, _react.css)([(0, _typography.h600)(), {
  marginTop: "var(--ds-space-0, 0px)",
  marginBottom: "var(--ds-space-200, 16px)"
}]);

/**
 * __Header__
 *
 * Header of Empty State.
 *
 * @internal
 */
var EmptyStateHeader = function EmptyStateHeader(_ref) {
  var children = _ref.children,
    _ref$level = _ref.level,
    level = _ref$level === void 0 ? 4 : _ref$level;
  var Tag = "h".concat(level > 0 && level < 7 ? level : level > 6 ? 6 : 4);
  return (0, _react.jsx)(Tag, {
    css: headerStyles
  }, children);
};
var _default = EmptyStateHeader;
exports.default = _default;