"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = require("@emotion/react");
/** @jsx jsx */

var CSS_VAR_MAX_WIDTH = '--max-width';
var CSS_VAR_MAX_HEIGHT = '--max-height';
var imageStyles = (0, _react.css)({
  display: 'block',
  maxWidth: "var(".concat(CSS_VAR_MAX_WIDTH, ")"),
  maxHeight: "var(".concat(CSS_VAR_MAX_HEIGHT, ")"),
  // eslint-disable-next-line @atlaskit/design-system/ensure-design-token-usage
  margin: "0 auto ".concat("var(--ds-space-300, 24px)")
});

/**
 * __Image__
 *
 * Image in Empty State.
 *
 * @internal
 */
var Image = function Image(_ref) {
  var _ref2;
  var maxHeight = _ref.maxHeight,
    maxWidth = _ref.maxWidth,
    _ref$height = _ref.height,
    height = _ref$height === void 0 ? 'auto' : _ref$height,
    _ref$width = _ref.width,
    width = _ref$width === void 0 ? 'auto' : _ref$width,
    src = _ref.src;
  return (0, _react.jsx)("img", {
    style: (_ref2 = {}, (0, _defineProperty2.default)(_ref2, CSS_VAR_MAX_WIDTH, "".concat(maxWidth, "px")), (0, _defineProperty2.default)(_ref2, CSS_VAR_MAX_HEIGHT, "".concat(maxHeight, "px")), _ref2),
    width: width,
    height: height,
    alt: "",
    role: "presentation",
    css: imageStyles,
    src: src
  });
};
var _default = Image;
exports.default = _default;