import React from 'react';
import ButtonGroup from '@atlaskit/button/button-group';
import Spinner from '@atlaskit/spinner';
import { ActionsContainer, Container, Description, Header, Image as HeaderImage, SpinnerContainer } from './styled';
/**
 * __Empty state__
 *
 * A component used for presenting various empty states.
 * e.g. (no items, empty search, broken link, welcome screen etc.)
 *
 * @example
 * ```tsx
 * import EmptyState from '@atlaskit/empty-state';
 *
 * // An example of a 404 state
 * export default () => {
 *  <EmptyState
 *   header="Page not found"
 *   imageUrl="https://cdn.io/images/404"
 *   description="Looks like you've stumbled off track. Sorry about that! This page either doesn't exist or has been removed."
 *   primaryAction={<Button appearance="primary">Home Page</Button>}
 *   secondaryAction={<Button>Report a problem</Button>}
 *  />;
 * };
 * ```
 */
const EmptyState = ({
  description,
  header,
  headingLevel = 4,
  imageHeight,
  imageUrl,
  imageWidth,
  isLoading,
  maxImageHeight = 160,
  maxImageWidth = 160,
  primaryAction,
  renderImage,
  secondaryAction,
  width,
  size,
  tertiaryAction,
  testId
}) => {
  const actionsContainer = primaryAction || secondaryAction || isLoading ? /*#__PURE__*/React.createElement(ActionsContainer, null, /*#__PURE__*/React.createElement(ButtonGroup, null, secondaryAction, primaryAction), /*#__PURE__*/React.createElement(SpinnerContainer, null, isLoading && /*#__PURE__*/React.createElement(Spinner, {
    testId: "empty-state-spinner"
  }))) : null;
  return /*#__PURE__*/React.createElement(Container, {
    testId: testId,
    width: width || size || 'wide'
  }, imageUrl ? /*#__PURE__*/React.createElement(HeaderImage, {
    src: imageUrl,
    maxWidth: maxImageWidth,
    maxHeight: maxImageHeight,
    width: imageWidth,
    height: imageHeight
  }) : renderImage && renderImage({
    maxImageWidth,
    maxImageHeight,
    imageWidth,
    imageHeight
  }), /*#__PURE__*/React.createElement(Header, {
    level: headingLevel
  }, header), description && /*#__PURE__*/React.createElement(Description, null, description), actionsContainer, tertiaryAction);
};
export default EmptyState;